/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.view.MatchState;

public class EnergyMatchDetector
implements AtomicState.Listener,
PhotonSource.WavelengthChangeListener {
    private LaserModel model;
    private AtomicState atomicState;
    private Beam beam;
    private Listener listener;

    public EnergyMatchDetector(LaserModel laserModel, AtomicState atomicState, Beam beam) {
        this(laserModel, atomicState, beam, null);
    }

    public EnergyMatchDetector(LaserModel laserModel, AtomicState atomicState, Beam beam, Listener listener) {
        this.model = laserModel;
        this.atomicState = atomicState;
        this.beam = beam;
        this.listener = listener;
        atomicState.addListener(this);
        beam.addWavelengthChangeListener(this);
        beam.addRateChangeListener(new PhotonSource.RateChangeListener(){

            public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
                EnergyMatchDetector.this.checkForMatch();
            }
        });
    }

    public void energyLevelChanged(AtomicState.Event event) {
        this.checkForMatch();
    }

    private void checkForMatch() {
        MatchState matchState = this.getMatch();
        if (this.listener != null) {
            this.listener.putMatch(this.beam, matchState);
        }
    }

    public MatchState getMatch() {
        double d = this.model.getGroundState().getEnergyLevel();
        double d2 = this.atomicState.getEnergyLevel() - d;
        double d3 = PhysicsUtil.wavelengthToEnergy(this.beam.getWavelength());
        boolean bl = this.beam.isEnabled() && this.beam.getPhotonsPerSecond() > 0.0 && MathUtil.isApproxEqual(d3, d2, 0.05);
        return new MatchState(bl, System.currentTimeMillis(), d3 + d, d, d2, d3);
    }

    public void meanLifetimeChanged(AtomicState.Event event) {
    }

    public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
        this.checkForMatch();
    }

    public static interface Listener {
        public void putMatch(Beam var1, MatchState var2);
    }
}

