/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.view;

import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.model.ConfigurableElementProperties;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSource;
import edu.colorado.phet.dischargelamps.view.DischargeLampEnergyLevelMonitorPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DischargeLampEnergyMonitorPanel2
extends JPanel {
    private DischargeLampEnergyLevelMonitorPanel elmp;
    private DischargeLampModel model;
    private JSpinner numLevelsSpinner;
    private JPanel spinnerPanel;
    private boolean showElectrons;

    public DischargeLampEnergyMonitorPanel2(final DischargeLampModel dischargeLampModel, AtomicState[] atomicStateArray, int n, int n2, final ConfigurableElementProperties configurableElementProperties) {
        super(new GridBagLayout());
        this.model = dischargeLampModel;
        dischargeLampModel.addChangeListener(new SpinnerManager());
        dischargeLampModel.getLeftHandPlate().addElectronProductionListener(new ElectronSource.ElectronProductionListener(){

            public void electronProduced(ElectronSource.ElectronProductionEvent electronProductionEvent) {
                if (DischargeLampEnergyMonitorPanel2.this.showElectrons) {
                    DischargeLampEnergyMonitorPanel2.this.addElectron(electronProductionEvent.getElectron());
                }
            }
        });
        dischargeLampModel.getRightHandPlate().addElectronProductionListener(new ElectronSource.ElectronProductionListener(){

            public void electronProduced(ElectronSource.ElectronProductionEvent electronProductionEvent) {
                if (DischargeLampEnergyMonitorPanel2.this.showElectrons) {
                    DischargeLampEnergyMonitorPanel2.this.addElectron(electronProductionEvent.getElectron());
                }
            }
        });
        this.elmp = new DischargeLampEnergyLevelMonitorPanel(dischargeLampModel, atomicStateArray, n, n2);
        this.elmp.setBorder(new EtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0);
        this.add((Component)this.elmp, gridBagConstraints);
        this.numLevelsSpinner = new JSpinner(new SpinnerNumberModel(2, 2, 6, 1));
        this.numLevelsSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)DischargeLampEnergyMonitorPanel2.this.numLevelsSpinner.getValue();
                configurableElementProperties.setNumEnergyLevels(n);
                dischargeLampModel.setElementProperties(configurableElementProperties);
            }
        });
        this.spinnerPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(DischargeLampsResources.getString("Controls.NumberOfLevels"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 2, 4, 2), 0, 0);
        gridBagConstraints2.anchor = 13;
        this.spinnerPanel.add((Component)jLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        this.spinnerPanel.add((Component)this.numLevelsSpinner, gridBagConstraints2);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.spinnerPanel, gridBagConstraints);
        this.setSpinnerVisibility(dischargeLampModel);
    }

    public void addElectron(Electron electron) {
        this.elmp.addElectron(electron);
    }

    public void reset() {
        this.elmp.setEnergyLevels(this.model.getAtomicStates());
        this.elmp.setEnergyLevelsMovable(this.model.getElementProperties().isLevelsMovable());
    }

    public void addAtom(Atom atom) {
        this.elmp.addAtom(atom);
    }

    public void setSquigglesEnabled(boolean bl) {
        this.elmp.setSquigglesEnabled(bl);
    }

    public DischargeLampEnergyLevelMonitorPanel getElmp() {
        return this.elmp;
    }

    private void setSpinnerVisibility(DischargeLampModel dischargeLampModel) {
        if (dischargeLampModel.getElementProperties() instanceof ConfigurableElementProperties) {
            this.spinnerPanel.setVisible(true);
        } else {
            this.spinnerPanel.setVisible(false);
        }
    }

    public void setShowElectrons(boolean bl) {
        this.showElectrons = bl;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    private class SpinnerManager
    extends DischargeLampModel.ChangeListenerAdapter {
        private SpinnerManager() {
        }

        public void energyLevelsChanged(DischargeLampModel.ChangeEvent changeEvent) {
            DischargeLampEnergyMonitorPanel2.this.setSpinnerVisibility(changeEvent.getDischargeLampModel());
        }
    }
}

