/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.model.Battery;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class BatteryReadout
extends GraphicLayerSet {
    private Point centerPoint;
    private JTextField readout;
    private PhetGraphic readoutGraphic;
    private boolean focusLossTemporary;

    public BatteryReadout(final Component component, final Battery battery, Point point, int n) {
        super(component);
        this.centerPoint = point;
        this.readout = new JTextField(5);
        this.readout.setHorizontalAlignment(0);
        this.readout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatteryReadout.this.setBatteryVoltage(battery, component);
            }
        });
        this.readout.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (!BatteryReadout.this.focusLossTemporary) {
                    BatteryReadout.this.setBatteryVoltage(battery, component);
                }
            }
        });
        this.readoutGraphic = PhetJComponent.newInstance(component, this.readout);
        this.addGraphic(this.readoutGraphic, 1.0E9);
        battery.addChangeListener(new Battery.ChangeListener(){

            public void voltageChanged(Battery.ChangeEvent changeEvent) {
                double d = changeEvent.getVoltageSource().getVoltage();
                BatteryReadout.this.update(d);
            }
        });
        this.update(battery.getVoltage());
    }

    private void setBatteryVoltage(Battery battery, Component component) {
        double d = 0.0;
        try {
            String string = this.readout.getText().toUpperCase();
            int n = string.indexOf(86);
            string = n >= 0 ? this.readout.getText().substring(0, n) : string;
            d = Double.parseDouble(string);
            double d2 = 30.0;
            if (d >= -d2 && d <= d2) {
                battery.setVoltage(d);
            } else {
                this.focusLossTemporary = true;
                PhetOptionPane.showErrorDialog(SwingUtilities.getRoot(component), "Voltage must be between -" + Double.toString(d2) + "V and " + Double.toString(d2) + "V");
                this.focusLossTemporary = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            PhetOptionPane.showErrorDialog(SwingUtilities.getRoot(component), "Voltage must be numeric, or a number followed by \"V\"");
            this.updateText(battery.getVoltage());
        }
    }

    private void update(double d) {
        this.updateText(d);
        this.readoutGraphic.setLocation((int)this.centerPoint.getX(), (int)this.centerPoint.getY());
        this.readoutGraphic.setBoundsDirty();
        this.readoutGraphic.repaint();
    }

    private void updateText(double d) {
        DecimalFormat decimalFormat = DischargeLampsConfig.VOLTAGE_FORMAT;
        Object[] objectArray = new Object[]{decimalFormat.format(d)};
        String string = decimalFormat.format(d);
        this.readout.setText(string);
    }
}

