/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.model;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.EnergyEmissionStrategy;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.model.DischargeLampElementProperties;
import edu.colorado.phet.dischargelamps.model.EnergyAbsorptionStrategy;
import edu.colorado.phet.dischargelamps.model.FallToAboveGroundState;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.lasers.model.LaserModel;
import java.util.EventListener;
import java.util.EventObject;

public class DischargeLampAtom
extends Atom {
    public static final double DEFAULT_STATE_LIFETIME = DischargeLampsConfig.DT / 25.0 * 100.0;
    private EnergyEmissionStrategy energyEmissionStrategy = new FallToAboveGroundState();
    private EnergyAbsorptionStrategy energyAbsorptionStrategy;
    private double baseRadius = Double.NEGATIVE_INFINITY;
    private EventChannel collisionEventChannel = new EventChannel(ElectronCollisionListener.class);
    private ElectronCollisionListener collisionListenerProxy = (ElectronCollisionListener)this.collisionEventChannel.getListenerProxy();

    public DischargeLampAtom(LaserModel laserModel, DischargeLampElementProperties dischargeLampElementProperties) {
        super(laserModel, dischargeLampElementProperties.getStates().length, true);
        if (dischargeLampElementProperties.getStates().length < 2) {
            throw new RuntimeException("Atom must have at least two states");
        }
        this.setElementProperties(dischargeLampElementProperties);
        this.setCurrState(dischargeLampElementProperties.getStates()[0]);
    }

    public void setRadius(double d) {
        if (this.baseRadius == Double.NEGATIVE_INFINITY) {
            this.baseRadius = d;
        }
        super.setRadius(d);
    }

    public double getBaseRadius() {
        return this.baseRadius;
    }

    public void collideWithElectron(Electron electron) {
        this.energyAbsorptionStrategy.collideWithElectron(this, electron);
        this.collisionListenerProxy.collisionOccurred(new ElectronCollisionEvent(this, electron));
    }

    public AtomicState getEnergyStateAfterEmission() {
        return this.energyEmissionStrategy.emitEnergy(this);
    }

    public void setElementProperties(DischargeLampElementProperties dischargeLampElementProperties) {
        super.setStates(dischargeLampElementProperties.getStates());
        this.energyAbsorptionStrategy = dischargeLampElementProperties.getEnergyAbsorptionStrategy();
        this.energyEmissionStrategy = dischargeLampElementProperties.getEnergyEmissionStrategy();
    }

    public void addElectronCollisionListener(ElectronCollisionListener electronCollisionListener) {
        this.collisionEventChannel.addListener(electronCollisionListener);
    }

    public void removeElectronCollisionListener(ElectronCollisionListener electronCollisionListener) {
        this.collisionEventChannel.removeListener(electronCollisionListener);
    }

    protected void emitPhoton(Photon photon) {
        super.emitPhoton(photon);
        double d = 0.5 / photon.getSpeed();
        photon.setVelocity(photon.getVelocity().getX() * d, photon.getVelocity().getY() * d);
    }

    public static class ElectronCollisionEvent
    extends EventObject {
        private Electron electron;

        public ElectronCollisionEvent(DischargeLampAtom dischargeLampAtom, Electron electron) {
            super(dischargeLampAtom);
            this.electron = electron;
        }

        public DischargeLampAtom getAtom() {
            return (DischargeLampAtom)this.getSource();
        }
    }

    public static interface ElectronCollisionListener
    extends EventListener {
        public void collisionOccurred(ElectronCollisionEvent var1);
    }
}

