/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.ModelEventChannel;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.dischargelamps.model.DischargeLampElementProperties;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSource;
import edu.colorado.phet.dischargelamps.quantum.model.Plate;
import edu.colorado.phet.photoelectric.model.Calcium;
import edu.colorado.phet.photoelectric.model.Copper;
import edu.colorado.phet.photoelectric.model.InitialElectronSpeedStrategy;
import edu.colorado.phet.photoelectric.model.Magnesium;
import edu.colorado.phet.photoelectric.model.MetalEnergyAbsorptionStrategy;
import edu.colorado.phet.photoelectric.model.Platinum;
import edu.colorado.phet.photoelectric.model.Sodium;
import edu.colorado.phet.photoelectric.model.Zinc;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Random;

public class PhotoelectricTarget
extends Plate {
    public static final DischargeLampElementProperties ZINC = new Zinc();
    public static final DischargeLampElementProperties COPPER = new Copper();
    public static final DischargeLampElementProperties SODIUM = new Sodium();
    public static final DischargeLampElementProperties PLATINUM = new Platinum();
    public static final DischargeLampElementProperties CALCIUM = new Calcium();
    public static final DischargeLampElementProperties MAGNESIUM = new Magnesium();
    public static final ArrayList TARGET_MATERIALS = new ArrayList();
    private Random random = new Random();
    private final Line2D line;
    private DischargeLampElementProperties targetMaterial;
    private InitialElectronSpeedStrategy initialElectronSpeedStrategy = new InitialElectronSpeedStrategy.Uniform(5.0E-16);
    private EventChannel materialChangeEventChannel = new ModelEventChannel(MaterialChangeListener.class);
    private MaterialChangeListener materialChangeListenerProxy = (MaterialChangeListener)this.materialChangeEventChannel.getListenerProxy();

    public PhotoelectricTarget(DischargeLampModel dischargeLampModel, Point2D point2D, Point2D point2D2) {
        super(dischargeLampModel, dischargeLampModel, point2D, point2D2);
        this.line = new Line2D.Double(point2D, point2D2);
    }

    public void handlePhotonCollision(Photon photon) {
        Object object;
        double d = 0.0;
        if (this.targetMaterial.getEnergyAbsorptionStrategy() instanceof MetalEnergyAbsorptionStrategy) {
            object = (MetalEnergyAbsorptionStrategy)this.targetMaterial.getEnergyAbsorptionStrategy();
            d = ((MetalEnergyAbsorptionStrategy)object).energyAfterPhotonCollision(photon);
        } else {
            d = photon.getEnergy() - this.targetMaterial.getWorkFunction();
        }
        if (d > 0.0) {
            object = MathUtil.getLineSegmentsIntersection(this.line.getP1(), this.line.getP2(), photon.getPosition(), photon.getPositionPrev());
            Electron electron = new Electron();
            double d2 = 1.0;
            electron.setPosition(((Point2D)object).getX() + d2, ((Point2D)object).getY());
            MutableVector2D mutableVector2D = this.determineNewElectronVelocity(d);
            electron.setVelocity(mutableVector2D);
            this.getSource().getElectronProductionListenerProxy().electronProduced(new ElectronSource.ElectronProductionEvent(this, electron));
        }
    }

    private MutableVector2D determineNewElectronVelocity(double d) {
        double d2 = this.initialElectronSpeedStrategy.determineNewElectronSpeed(d);
        double d3 = 0.0;
        double d4 = this.random.nextDouble() * d3 - d3 / 2.0;
        double d5 = d2 * Math.cos(d4);
        double d6 = d2 * Math.sin(d4);
        return new MutableVector2D(d5, d6);
    }

    public boolean isHitByPhoton(Photon photon) {
        boolean bl = this.line.intersectsLine(photon.getPosition().getX(), photon.getPosition().getY(), photon.getPositionPrev().getX(), photon.getPositionPrev().getY());
        return bl;
    }

    public void setTargetMaterial(DischargeLampElementProperties dischargeLampElementProperties) {
        this.targetMaterial = dischargeLampElementProperties;
        if (!TARGET_MATERIALS.contains(dischargeLampElementProperties)) {
            throw new RuntimeException("Invalid parameter");
        }
        this.materialChangeListenerProxy.materialChanged(new MaterialChangeEvent(this));
    }

    public DischargeLampElementProperties getMaterial() {
        return this.targetMaterial;
    }

    public void setUniformInitialElectronSpeedStrategy() {
        this.initialElectronSpeedStrategy = new InitialElectronSpeedStrategy.Uniform(5.0E-16);
    }

    public void setRandomizedInitialElectronSpeedStrategy() {
        this.initialElectronSpeedStrategy = new InitialElectronSpeedStrategy.Randomized(5.0E-16, 0.1);
    }

    public void addListener(ElectronSource.ElectronProductionListener electronProductionListener) {
        this.getSource().addListener(electronProductionListener);
    }

    void addMaterialChangeListener(MaterialChangeListener materialChangeListener) {
        this.materialChangeEventChannel.addListener(materialChangeListener);
    }

    static {
        TARGET_MATERIALS.add(ZINC);
        TARGET_MATERIALS.add(COPPER);
        TARGET_MATERIALS.add(SODIUM);
        TARGET_MATERIALS.add(PLATINUM);
        TARGET_MATERIALS.add(CALCIUM);
        TARGET_MATERIALS.add(MAGNESIUM);
    }

    class MaterialChangeEvent
    extends EventObject {
        MaterialChangeEvent(Object object) {
            super(object);
        }
    }

    public static interface MaterialChangeListener
    extends EventListener {
        public void materialChanged(MaterialChangeEvent var1);
    }
}

