/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.lasers.LasersConfig;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.model.mirror.PartialMirror;
import edu.colorado.phet.lasers.view.NonLasingWaveGraphic;
import edu.colorado.phet.lasers.view.StandingWaveGraphic;
import edu.colorado.phet.lasers.view.TravelingWaveGraphic;
import edu.colorado.phet.lasers.view.WaveGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class LaserWaveGraphic
implements LaserModel.ChangeListener {
    public static double scaleFactor = 10.0;
    public static double cyclesInCavity = 10.0;
    private Point2D internalWaveOrigin;
    private Point2D externalWaveOrigin;
    private StandingWaveGraphic internalStandingWaveGraphic;
    private TravelingWaveGraphic externalTravelingWaveGraphic;
    private int numNonLasingExternalWaveGraphics = 5;
    private WaveGraphic[] nonLasingExternalWaveGraphics = new WaveGraphic[this.numNonLasingExternalWaveGraphics];
    private Stroke stroke = new BasicStroke(2.0f);
    private PartialMirror mirror;
    private int numLasingPhotons;

    public LaserWaveGraphic(ApparatusPanel apparatusPanel, Tube tube, PartialMirror partialMirror, BaseLaserModule baseLaserModule, final AtomicState[] atomicStateArray) {
        int n;
        LaserModel laserModel = baseLaserModule.getLaserModel();
        laserModel.addLaserListener(this);
        this.mirror = partialMirror;
        Color color = Color.white;
        this.internalWaveOrigin = new Point2D.Double(tube.getMinX(), tube.getMinY() + tube.getHeight() / 2.0);
        this.internalStandingWaveGraphic = new StandingWaveGraphic((Component)apparatusPanel, this.internalWaveOrigin, tube.getWidth(), tube.getWidth() / cyclesInCavity, 100.0, (double)this.getNumLasingPhotons(), color, laserModel);
        this.externalWaveOrigin = new Point2D.Double(tube.getMinX() + tube.getWidth(), tube.getMinY() + tube.getHeight() / 2.0);
        this.externalTravelingWaveGraphic = new TravelingWaveGraphic((Component)apparatusPanel, this.externalWaveOrigin, 400.0, tube.getWidth() / cyclesInCavity, 100.0, (double)this.getNumLasingPhotons(), color, laserModel);
        double d = 20.0;
        double d2 = tube.getHeight() / (double)this.numNonLasingExternalWaveGraphics;
        int n2 = this.numNonLasingExternalWaveGraphics / 2;
        for (n = 0; n < this.numNonLasingExternalWaveGraphics; ++n) {
            double d3 = (double)(n - n2) * d;
            double d4 = (double)(n - n2) * d2;
            Point2D.Double double_ = new Point2D.Double(tube.getMinX() + tube.getWidth(), tube.getMinY() + tube.getHeight() / 2.0 + d4);
            NonLasingWaveGraphic nonLasingWaveGraphic = new NonLasingWaveGraphic(apparatusPanel, double_, tube.getWidth(), tube.getWidth() / cyclesInCavity, 100.0, this.getNumLasingPhotons(), color, baseLaserModule, Math.toRadians(d3));
            this.nonLasingExternalWaveGraphics[n] = nonLasingWaveGraphic;
        }
        apparatusPanel.addGraphic(this.internalStandingWaveGraphic, 13.0);
        apparatusPanel.addGraphic(this.externalTravelingWaveGraphic, 10.0);
        for (n = 0; n < this.nonLasingExternalWaveGraphics.length; ++n) {
            apparatusPanel.addGraphic(this.nonLasingExternalWaveGraphics[n], 10.0);
        }
        atomicStateArray[1].addListener(new AtomicState.Listener(){

            public void energyLevelChanged(AtomicState.Event event) {
                LaserWaveGraphic.this.determineColor(atomicStateArray);
            }

            public void meanLifetimeChanged(AtomicState.Event event) {
            }
        });
        atomicStateArray[0].addListener(new AtomicState.Listener(){

            public void energyLevelChanged(AtomicState.Event event) {
                LaserWaveGraphic.this.determineColor(atomicStateArray);
            }

            public void meanLifetimeChanged(AtomicState.Event event) {
            }
        });
        this.determineColor(atomicStateArray);
    }

    private void determineColor(AtomicState[] atomicStateArray) {
        double d = PhysicsUtil.energyToWavelength(atomicStateArray[1].getEnergyLevel() - atomicStateArray[0].getEnergyLevel());
        Color color = VisibleColor.wavelengthToColor(d);
        if (color.getAlpha() == 0) {
            color = Color.gray;
        }
        this.externalTravelingWaveGraphic.setColor(color);
        this.internalStandingWaveGraphic.setColor(color);
        for (int i = 0; i < this.nonLasingExternalWaveGraphics.length; ++i) {
            WaveGraphic waveGraphic = this.nonLasingExternalWaveGraphics[i];
            waveGraphic.setColor(color);
        }
    }

    public void setVisible(boolean bl) {
        this.internalStandingWaveGraphic.setVisible(bl);
        this.externalTravelingWaveGraphic.setVisible(bl);
        for (int i = 0; i < this.nonLasingExternalWaveGraphics.length; ++i) {
            this.nonLasingExternalWaveGraphics[i].setVisible(bl);
        }
    }

    private int getNumLasingPhotons() {
        return this.numLasingPhotons;
    }

    private double getExternalAmplitude() {
        double d = this.getInternalAmplitude();
        if (this.mirror != null) {
            return d * Math.sqrt(1.0 - this.mirror.getReflectivity());
        }
        return 0.0;
    }

    private double getInternalAmplitude() {
        double d = 4.0 * Math.sqrt(Math.max(0, this.getNumLasingPhotons() - LasersConfig.LASING_THRESHOLD));
        return d;
    }

    private void update() {
        this.internalStandingWaveGraphic.setAmplitude(this.getInternalAmplitude());
        this.externalTravelingWaveGraphic.setAmplitude(this.getExternalAmplitude());
        for (int i = 0; i < this.nonLasingExternalWaveGraphics.length; ++i) {
            WaveGraphic waveGraphic = this.nonLasingExternalWaveGraphics[i];
            int n = this.getNumLasingPhotons() > LasersConfig.LASING_THRESHOLD ? 0 : this.getNumLasingPhotons() / 6;
            waveGraphic.setAmplitude(n);
        }
    }

    public void lasingPopulationChanged(LaserModel.ChangeEvent changeEvent) {
        int n = changeEvent.getLasingPopulation();
        if (n != this.numLasingPhotons) {
            this.numLasingPhotons = n;
            this.update();
        }
    }

    public void atomicStatesChanged(LaserModel.ChangeEvent changeEvent) {
        AtomicState[] atomicStateArray = new AtomicState[]{changeEvent.getLaserModel().getGroundState(), changeEvent.getLaserModel().getMiddleEnergyState()};
        this.determineColor(atomicStateArray);
        this.update();
    }
}

