/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view.help;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShadowTextGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class HelpItem
extends PhetGraphic {
    public static final Font DEFAULT_FONT = new PhetFont(1, 16);
    PhetShapeGraphic backgroundGraphic;
    ArrayList shadowTextGraphics = new ArrayList();
    int horizontalAlignment;
    int verticalAlignment;
    private Font font = DEFAULT_FONT;
    private String text;
    private Point2D.Double location;
    private Color shadowColor;
    private Color foregroundColor;
    private boolean inited = false;
    private boolean antiAlias = false;

    private static String[] tokenizeString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    public HelpItem(Component component, String string, Point2D point2D, int n, int n2) {
        this(component, string, point2D.getX(), point2D.getY(), n, n2);
    }

    public HelpItem(Component component, String string, double d, double d2, int n, int n2) {
        super(component);
        this.horizontalAlignment = n;
        this.verticalAlignment = n2;
        this.text = string;
        this.location = new Point2D.Double(d, d2);
        this.shadowColor = Color.black;
        this.foregroundColor = new Color(156, 156, 0);
        this.setIgnoreMouse(true);
    }

    private void init(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        this.shadowTextGraphics = new ArrayList();
        String[] stringArray = HelpItem.tokenizeString(this.text);
        int n = 0;
        double d = 0.0;
        switch (this.horizontalAlignment) {
            case 3: {
                d = this.getMaxStrLen(stringArray, graphics2D, fontMetrics);
                n = (int)(this.location.getX() - d - fontMetrics.getStringBounds(" ", graphics2D).getWidth());
                break;
            }
            case 5: {
                n = (int)(this.location.getX() + fontMetrics.getStringBounds(" ", graphics2D).getWidth());
                break;
            }
            case 4: {
                d = this.getMaxStrLen(stringArray, graphics2D, fontMetrics);
                n = (int)(this.location.getX() - d / 2.0);
            }
        }
        double d2 = 0.0;
        switch (this.verticalAlignment) {
            case 1: {
                d2 = -stringArray.length * (fontMetrics.getHeight() + fontMetrics.getLeading());
                break;
            }
            case 2: {
                d2 = 0.0;
                break;
            }
            case 4: {
                d2 = -(stringArray.length + 1) * (fontMetrics.getHeight() + fontMetrics.getLeading()) / 2;
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = (int)d2 + (int)this.location.getY() + (i + 1) * (fontMetrics.getHeight() + fontMetrics.getLeading());
            PhetShadowTextGraphic phetShadowTextGraphic = new PhetShadowTextGraphic(this.getComponent(), this.font, stringArray[i], this.foregroundColor, 1, 1, this.shadowColor);
            phetShadowTextGraphic.setLocation(n, n2);
            this.shadowTextGraphics.add(phetShadowTextGraphic);
        }
    }

    protected Rectangle determineBounds() {
        return this.getComponent().getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (this.antiAlias) {
            GraphicsUtil.setAntiAliasingOn(graphics2D);
        }
        if (!this.inited) {
            this.init(graphics2D);
            this.inited = true;
        }
        if (this.backgroundGraphic != null) {
            this.backgroundGraphic.paint(graphics2D);
        }
        for (int i = 0; i < this.shadowTextGraphics.size(); ++i) {
            PhetShadowTextGraphic phetShadowTextGraphic = (PhetShadowTextGraphic)this.shadowTextGraphics.get(i);
            phetShadowTextGraphic.paint(graphics2D);
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    public void setLocation(int n, int n2) {
        this.location.setLocation(n, n2);
        this.inited = false;
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
        for (int i = 0; i < this.shadowTextGraphics.size(); ++i) {
            PhetShadowTextGraphic phetShadowTextGraphic = (PhetShadowTextGraphic)this.shadowTextGraphics.get(i);
            phetShadowTextGraphic.setShadowColor(color);
        }
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
        for (int i = 0; i < this.shadowTextGraphics.size(); ++i) {
            PhetShadowTextGraphic phetShadowTextGraphic = (PhetShadowTextGraphic)this.shadowTextGraphics.get(i);
            phetShadowTextGraphic.setColor(color);
        }
    }

    private double getMaxStrLen(String[] stringArray, Graphics2D graphics2D, FontMetrics fontMetrics) {
        double d = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            double d2 = fontMetrics.getStringBounds(string, graphics2D).getWidth();
            d = d2 > d ? d2 : d;
        }
        return d;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
    }

    public void setDisplayDropShadow(boolean bl) {
        if (bl) {
            this.setShadowColor(this.shadowColor);
        } else {
            this.setShadowColor(new Color(0, 0, 0, 0));
        }
    }
}

