/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing.components;

import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJButton;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJMenuItem;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.util.FileUtils;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class SimSharingLogMenuItem
extends SimSharingJMenuItem {
    private SimSharingLogDialog dialog;

    public SimSharingLogMenuItem(final PhetFrame phetFrame) {
        super(UserComponents.dataCollectionLogMenuItem, "Data Collection Log...");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SimSharingLogMenuItem.this.dialog == null) {
                    SimSharingLogMenuItem.this.dialog = new SimSharingLogDialog(phetFrame);
                }
                SimSharingLogMenuItem.this.dialog.setVisible(true);
            }
        });
    }

    public static class SimSharingLogDialog
    extends JDialog {
        private File currentDirectory = null;

        public SimSharingLogDialog(final JFrame jFrame) {
            super((Frame)jFrame, "Data Collection Log");
            this.setContentPane(new JPanel(new BorderLayout()){
                {
                    super(layoutManager);
                    this.add((Component)new JScrollPane(new JTextArea(20, 40){
                        {
                            this.setEditable(false);
                            SimSharingManager.getInstance().stringLog.log.addObserver(new VoidFunction1<String>(){

                                @Override
                                public void apply(String string) {
                                    this.setText(string);
                                    this.scrollRectToVisible(new Rectangle(0, this.getHeight() - 1, 1, 1));
                                }
                            });
                        }
                    }), "Center");
                    this.add((Component)new JPanel(){
                        {
                            this.add(new SimSharingJButton(UserComponentChain.chain(UserComponents.simSharingLogFileDialog, UserComponents.saveButton), "Save..."){
                                {
                                    this.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent actionEvent) {
                                            Object object;
                                            JFileChooser jFileChooser = new JFileChooser(SimSharingLogDialog.this.currentDirectory);
                                            jFileChooser.setDialogTitle("Data Collection Log : Save");
                                            int n = jFileChooser.showSaveDialog(jFrame);
                                            File file = jFileChooser.getSelectedFile();
                                            if (n == 1 || file == null) {
                                                SimSharingManager.sendUserMessage(UserComponentChain.chain(UserComponents.simSharingLogFileDialog, UserComponents.fileChooserCancelButton), UserComponentTypes.button, UserActions.pressed);
                                                return;
                                            }
                                            SimSharingLogDialog.this.currentDirectory = file.getParentFile();
                                            SimSharingManager.sendUserMessage(UserComponentChain.chain(UserComponents.simSharingLogFileDialog, UserComponents.fileChooserSaveButton), UserComponentTypes.button, UserActions.pressed);
                                            if (!FileUtils.hasSuffix(file, ".txt")) {
                                                file = new File(file.getParent(), file.getName() + ".txt");
                                            }
                                            if (file.exists()) {
                                                object = MessageFormat.format("File {0} exists. OK to replace?", file.getName());
                                                int n2 = PhetOptionPane.showYesNoDialog(jFrame, object, "Confirm");
                                                if (n2 != 0) {
                                                    SimSharingManager.sendUserMessage(UserComponentChain.chain(UserComponents.simSharingLogFileDialog, UserComponents.replaceFileNoButton), UserComponentTypes.button, UserActions.pressed);
                                                    return;
                                                }
                                                SimSharingManager.sendUserMessage(UserComponentChain.chain(UserComponents.simSharingLogFileDialog, UserComponents.replaceFileYesButton), UserComponentTypes.button, UserActions.pressed);
                                            }
                                            try {
                                                object = new BufferedWriter(new FileWriter(file));
                                                ((Writer)object).write(SimSharingManager.getInstance().stringLog.log.get());
                                                ((BufferedWriter)object).close();
                                            }
                                            catch (IOException iOException) {
                                                iOException.printStackTrace();
                                            }
                                        }
                                    });
                                }
                            });
                            this.add(new SimSharingJButton(UserComponents.showLogs, "Standard Logs..."){
                                {
                                    this.addActionListener(new ActionListener(){
                                        JDialog logListDialog = null;

                                        public void actionPerformed(ActionEvent actionEvent) {
                                            if (this.logListDialog == null) {
                                                this.logListDialog = new JDialog(jFrame, "Standard Logs"){
                                                    {
                                                        this.setResizable(false);
                                                        this.setContentPane(new VerticalLayoutPanel(){
                                                            {
                                                                this.setBorder(new EmptyBorder(10, 10, 10, 10));
                                                                this.setInsets(new Insets(5, 5, 5, 5));
                                                                this.add(new JLabel("Data is being logged to these standard locations:"){
                                                                    {
                                                                        this.setFont(new PhetFont(1, 12));
                                                                    }
                                                                });
                                                                this.add(new JTextArea(new ObservableList<String>(SimSharingManager.getInstance().getLogNames()).mkString("\n")){
                                                                    {
                                                                        this.setEditable(false);
                                                                        this.setOpaque(false);
                                                                        this.setFont(new PhetFont(12));
                                                                    }
                                                                });
                                                            }
                                                        });
                                                    }
                                                };
                                                this.logListDialog.pack();
                                                SwingUtils.centerInParent(this.logListDialog);
                                            }
                                            this.logListDialog.setVisible(true);
                                        }
                                    });
                                }
                            });
                        }
                    }, "South");
                }
            });
            this.pack();
            SwingUtils.centerInParent(this);
        }
    }
}

