/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;

public class HTMLNode
extends PNode {
    private static final Font DEFAULT_FONT = new PhetFont(1, 12);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private String html;
    private Color color;
    private Font font;
    private final JLabel label;

    public HTMLNode() {
        this(null, DEFAULT_COLOR, DEFAULT_FONT);
    }

    public HTMLNode(String string) {
        this(string, DEFAULT_COLOR, DEFAULT_FONT);
    }

    public HTMLNode(String string, Color color, Font font) {
        this.html = HTMLUtils.toHTMLString(string);
        this.color = color;
        this.font = font;
        this.label = new JLabel();
        this.update();
    }

    public String getHTML() {
        return this.html;
    }

    public void setHTML(String string) {
        String string2 = HTMLUtils.toHTMLString(string);
        if (string2 == null && this.html == null || string2 != null && string2.equals(this.html)) {
            return;
        }
        this.html = string2;
        this.update();
    }

    public void setFont(Font font) {
        this.font = font;
        this.update();
    }

    public void setHTMLColor(Color color) {
        this.color = color;
        this.update();
    }

    private void update() {
        this.label.setText(this.html);
        this.label.setFont(this.font);
        this.label.setForeground(this.color);
        this.label.setSize(this.label.getPreferredSize());
        this.setBounds(0.0, 0.0, this.label.getPreferredSize().getWidth(), this.label.getPreferredSize().getHeight());
        this.repaint();
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        Graphics2D graphics2D = pPaintContext.getGraphics();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        this.label.paint(graphics2D);
        graphics2D.setRenderingHints(renderingHints);
    }
}

