/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.Capacitor3DShapeSet;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitInteractionModel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentNode;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class CapacitorNode
extends ComponentNode {
    private CCKModel model;
    private CCKModule module;
    private Capacitor capacitor;
    private static final Color tan = new Color(255, 220, 130);
    private Color plate1Color = tan;
    private Color plate2Color = tan;
    private double tiltAngle = 0.7853981633974483;
    private int width = 50;
    private int height = 100;
    private int distBetweenPlates = 20;
    private Capacitor3DShapeSet capacitor3DShapeSet;
    private PlateNode leftPlate;
    private PlateNode rightPlate;
    private CircuitInteractionModel circuitInteractionModel;
    private double scale = 0.0125;
    private WireStubNode rightWire;
    private WireStubNode leftWire;
    private int numToShow = 0;
    private SimpleObserver capacitorObserver = new SimpleObserver(){

        public void update() {
            CapacitorNode.this.update();
        }
    };
    double SCALE = 0.016666666666666666;

    public CapacitorNode(CCKModel cCKModel, Capacitor capacitor, JComponent jComponent, CCKModule cCKModule) {
        super(cCKModel, capacitor, jComponent, cCKModule);
        this.model = cCKModel;
        this.module = cCKModule;
        this.circuitInteractionModel = new CircuitInteractionModel(cCKModel);
        this.capacitor = capacitor;
        capacitor.addObserver(this.capacitorObserver);
        this.leftPlate = new PlateNode();
        this.rightPlate = new PlateNode();
        this.rightWire = new WireStubNode();
        this.leftWire = new WireStubNode();
        this.addChild(this.rightWire);
        this.addChild(this.rightPlate);
        this.addChild(this.leftPlate);
        this.addChild(this.leftWire);
        this.getHighlightNode().setStroke(new BasicStroke(0.09f));
        this.update();
    }

    public void delete() {
        super.delete();
        this.capacitor.removeObserver(this.capacitorObserver);
    }

    public Shape getClipShape(PNode pNode) {
        Shape shape = this.getPlateClipShape(this.leftPlate.getPath(), pNode);
        Shape shape2 = this.getPlateClipShape(this.rightPlate.getPath(), pNode);
        Area area = new Area(shape);
        area.add(new Area(shape2));
        Shape shape3 = this.leftWire.getPathBoundExpanded();
        PAffineTransform pAffineTransform = this.leftWire.getPath().getLocalToGlobalTransform(null);
        PAffineTransform pAffineTransform2 = pNode.getGlobalToLocalTransform(null);
        shape3 = pAffineTransform.createTransformedShape(shape3);
        shape3 = pAffineTransform2.createTransformedShape(shape3);
        area.subtract(new Area(shape3));
        return area;
    }

    private Shape getPlateClipShape(PhetPPath phetPPath, PNode pNode) {
        Shape shape = phetPPath.getPathReference();
        PAffineTransform pAffineTransform = phetPPath.getLocalToGlobalTransform(null);
        PAffineTransform pAffineTransform2 = pNode.getGlobalToLocalTransform(null);
        shape = pAffineTransform.createTransformedShape(shape);
        shape = pAffineTransform2.createTransformedShape(shape);
        return shape;
    }

    public void update() {
        super.update();
        this.capacitor3DShapeSet = new Capacitor3DShapeSet(this.tiltAngle, this.getCapacitorWidth() * this.scale, this.getCapacitorHeight() * this.scale, this.capacitor.getStartPoint(), this.capacitor.getEndPoint(), (double)this.distBetweenPlates * this.scale);
        this.leftPlate.setPlateShape(this.capacitor3DShapeSet.getPlate1Shape());
        this.rightPlate.setPlateShape(this.capacitor3DShapeSet.getPlate2Shape());
        this.leftWire.setWireStubShape(this.capacitor3DShapeSet.getPlate1Wire());
        this.rightWire.setWireStubShape(this.capacitor3DShapeSet.getPlate2Wire());
        this.getHighlightNode().setPathTo(this.capacitor3DShapeSet.getPlateArea());
        this.updateChargeDisplay();
    }

    private double getCapacitorHeight() {
        return this.height;
    }

    private double getCapacitorWidth() {
        return this.width;
    }

    public Branch getBranch() {
        return this.capacitor;
    }

    private void updateChargeDisplay() {
        double d = 1.0;
        double d2 = 100.0;
        int n = (int)Math.min(Math.abs(this.capacitor.getCharge()) / d * d2, d2);
        this.setNumDisplayedCharges(n);
    }

    private void setNumDisplayedCharges(int n) {
        this.numToShow = n;
        this.leftPlate.removeChargeGraphics();
        this.rightPlate.removeChargeGraphics();
        ChargeGraphic chargeGraphic = new ChargeGraphic(){

            public Shape createGraphic(Point2D point2D) {
                return CapacitorNode.this.capacitor.getCharge() > 0.0 ? CapacitorNode.this.createPlusGraphic(point2D) : CapacitorNode.this.createMinusGraphic(point2D);
            }
        };
        ChargeGraphic chargeGraphic2 = new ChargeGraphic(){

            public Shape createGraphic(Point2D point2D) {
                return !(CapacitorNode.this.capacitor.getCharge() > 0.0) ? CapacitorNode.this.createPlusGraphic(point2D) : CapacitorNode.this.createMinusGraphic(point2D);
            }
        };
        Color color = this.capacitor.getCharge() > 0.0 ? Color.red : Color.blue;
        Color color2 = !(this.capacitor.getCharge() > 0.0) ? Color.red : Color.blue;
        double d = this.capacitor3DShapeSet.getWidth();
        double d2 = this.capacitor3DShapeSet.getLength();
        double d3 = Math.sqrt((double)n / d / d2);
        int n2 = (int)(d * d3);
        int n3 = (int)(d2 * d3);
        double d4 = d / (double)n2;
        double d5 = d2 / (double)n3;
        double d6 = d4 / 2.0;
        double d7 = d5 / 2.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (n2 == 1) {
            d8 = 5.0 * this.SCALE;
            d9 = 0.0;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d10 = -d / 2.0 + (double)i * d4 + d6 + d8;
                double d11 = -d2 / 2.0 + (double)j * d5 + d7 + d9;
                Point2D point2D = this.capacitor3DShapeSet.getPlate1Location(d10, d11);
                Point2D point2D2 = this.capacitor3DShapeSet.getPlate2Location(d10, d11);
                this.leftPlate.addChargeNode(new PhetPPath(chargeGraphic.createGraphic(point2D), (Paint)color));
                this.rightPlate.addChargeNode(new PhetPPath(chargeGraphic2.createGraphic(point2D2), (Paint)color2));
            }
        }
    }

    private Shape createPlusGraphic(Point2D point2D) {
        double d = 2.0 * this.SCALE;
        Area area = new Area(new Rectangle2D.Double(point2D.getX() - d, point2D.getY(), d * 2.0 + 1.0 * this.SCALE, 1.0 * this.SCALE));
        area.add(new Area(new Rectangle2D.Double(point2D.getX(), point2D.getY() - d, 1.0 * this.SCALE, d * 2.0 + 1.0 * this.SCALE)));
        return area;
    }

    private Shape createMinusGraphic(Point2D point2D) {
        double d = 2.0 * this.SCALE;
        return new Area(new Rectangle2D.Double(point2D.getX() - d, point2D.getY(), d * 2.0 + 1.0 * this.SCALE, 1.0 * this.SCALE));
    }

    private static interface ChargeGraphic {
        public Shape createGraphic(Point2D var1);
    }

    class PlateNode
    extends PhetPNode {
        private PhetPPath path;
        private PhetPNode chargeLayer = new PhetPNode();

        public PlateNode() {
            this.path = new PhetPPath(tan, (Stroke)new BasicStroke(0.016666668f), (Paint)Color.black);
            this.addChild(this.path);
            this.addChild(this.chargeLayer);
        }

        public void setPlateShape(Shape shape) {
            this.path.setPathTo(shape);
        }

        public void removeChargeGraphics() {
            this.chargeLayer.removeAllChildren();
        }

        public void addChargeNode(PNode pNode) {
            this.chargeLayer.addChild(pNode);
        }

        public PhetPPath getPath() {
            return this.path;
        }
    }

    class WireStubNode
    extends PhetPNode {
        private PhetPPath path;
        private PhetPPath clipPath;

        public WireStubNode() {
            BasicStroke basicStroke = new BasicStroke(0.175f, 0, 0);
            this.path = new PhetPPath(basicStroke, (Paint)Color.black);
            this.clipPath = new PhetPPath(new BasicStroke(0.35f, 0, 0), (Paint)Color.black);
            this.addChild(this.path);
        }

        public void setWireStubShape(Shape shape) {
            this.path.setPathTo(shape);
            this.clipPath.setPathTo(shape);
        }

        public PhetPPath getPath() {
            return this.path;
        }

        public Shape getPathBoundExpanded() {
            return this.clipPath.getPathBoundsWithStroke();
        }
    }
}

