/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.view.chart.AbstractFloatingChart;
import edu.colorado.phet.circuitconstructionkit.view.chart.CurrentStripChart;
import edu.colorado.phet.circuitconstructionkit.view.chart.VoltageStripChart;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;

public class ChartSetNode
extends PhetPNode {
    private CCKSimulationPanel cckSimulationPanel;
    private Circuit circuit;
    private IClock clock;

    public ChartSetNode(CCKSimulationPanel cCKSimulationPanel, Circuit circuit, IClock iClock) {
        this.cckSimulationPanel = cCKSimulationPanel;
        this.circuit = circuit;
        this.clock = iClock;
    }

    public void addCurrentChart() {
        final CurrentStripChart currentStripChart = new CurrentStripChart((PhetPCanvas)this.cckSimulationPanel, CCKStrings.getString("current-y-axis"), this.clock, this.getCircuit(), this.cckSimulationPanel);
        currentStripChart.translate(210.0, 210.0);
        this.addChild(currentStripChart);
        currentStripChart.addListener(new AbstractFloatingChart.Listener(){

            public void chartClosing() {
                ChartSetNode.this.removeChild(currentStripChart);
            }
        });
    }

    private Circuit getCircuit() {
        return this.circuit;
    }

    public void addVoltageChart() {
        final VoltageStripChart voltageStripChart = new VoltageStripChart(this.cckSimulationPanel, "Current", this.clock, this.getCircuit());
        voltageStripChart.translate(280.0, 280.0);
        this.addChild(voltageStripChart);
        voltageStripChart.addListener(new AbstractFloatingChart.Listener(){

            public void chartClosing() {
                ChartSetNode.this.removeChild(voltageStripChart);
            }
        });
    }
}

