/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.chart;

import edu.colorado.phet.circuitconstructionkit.view.chart.AbstractFloatingChart;
import edu.colorado.phet.circuitconstructionkit.view.chart.CrosshairConnection;
import edu.colorado.phet.circuitconstructionkit.view.chart.CrosshairNode;
import edu.colorado.phet.circuitconstructionkit.view.chart.StripChartJFCNode;
import edu.colorado.phet.circuitconstructionkit.view.chart.TwoTerminalValueReader;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class DoubleTerminalFloatingChart
extends AbstractFloatingChart {
    private CrosshairNode leftCrosshairNode;
    private CrosshairNode rightCrosshairNode;
    private TwoTerminalValueReader valueReader;
    private PhetPCanvas phetPCanvas;

    public DoubleTerminalFloatingChart(PhetPCanvas phetPCanvas, String string, TwoTerminalValueReader twoTerminalValueReader, IClock iClock) {
        super(string, iClock);
        this.valueReader = twoTerminalValueReader;
        this.phetPCanvas = phetPCanvas;
        this.leftCrosshairNode = new CrosshairNode(this, 10, 15);
        this.rightCrosshairNode = new CrosshairNode(this, 10, 15);
        CrosshairConnection crosshairConnection = new CrosshairConnection(this, this.leftCrosshairNode);
        this.addChild(crosshairConnection);
        CrosshairConnection crosshairConnection2 = new CrosshairConnection(this, this.rightCrosshairNode);
        this.addChild(crosshairConnection2);
        this.addChild(this.leftCrosshairNode);
        this.addChild(this.rightCrosshairNode);
        StripChartJFCNode stripChartJFCNode = super.getStripChartJFCNode();
        stripChartJFCNode.setOffset(-stripChartJFCNode.getFullBounds().getWidth() - this.leftCrosshairNode.getFullBounds().getWidth() / 2.0, -stripChartJFCNode.getFullBounds().getHeight() / 2.0);
        double d = this.leftCrosshairNode.getFullBounds().getWidth() * 1.25;
        this.leftCrosshairNode.translate(d, -30.0);
        this.rightCrosshairNode.translate(d, 30.0);
        stripChartJFCNode.addInputEventListener(new PairDragHandler());
    }

    public CrosshairNode getLeftCrosshairGraphic() {
        return this.leftCrosshairNode;
    }

    public CrosshairNode getRightCrosshairGraphic() {
        return this.rightCrosshairNode;
    }

    public void update() {
        super.update();
        if (this.leftCrosshairNode != null && this.valueReader != null) {
            double d = this.valueReader.getValue(this.getLeftShape(), this.getRightShape());
            double d2 = super.getClock().getSimulationTime();
            this.getStripChartJFCNode().addValue(d2, d);
        }
    }

    protected abstract Shape getRightShape();

    protected abstract Shape getLeftShape();

    public void setValueReader(TwoTerminalValueReader twoTerminalValueReader) {
        this.valueReader = twoTerminalValueReader;
        this.update();
    }

    class PairDragHandler
    extends PDragEventHandler {
        PairDragHandler() {
        }

        protected void drag(PInputEvent pInputEvent) {
            super.drag(pInputEvent);
            if (DoubleTerminalFloatingChart.this.leftCrosshairNode.isAttached()) {
                DoubleTerminalFloatingChart.this.leftCrosshairNode.translate(pInputEvent.getCanvasDelta().getWidth(), pInputEvent.getCanvasDelta().getHeight());
            }
        }
    }

    public static class Piccolo
    extends DoubleTerminalFloatingChart {
        private CCKSimulationPanel cckSimulationPanel;

        public Piccolo(CCKSimulationPanel cCKSimulationPanel, String string, TwoTerminalValueReader twoTerminalValueReader, IClock iClock) {
            super(cCKSimulationPanel, string, twoTerminalValueReader, iClock);
            this.cckSimulationPanel = cCKSimulationPanel;
        }

        protected Shape getRightShape() {
            return this.getShape(this.getRightCrosshairGraphic());
        }

        private Shape getShape(PNode pNode) {
            Point2D point2D = pNode.getGlobalTranslation();
            this.cckSimulationPanel.getCircuitNode().globalToLocal(point2D);
            return new Rectangle2D.Double(point2D.getX(), point2D.getY(), 0.01, 0.01);
        }

        protected Shape getLeftShape() {
            return this.getShape(this.getLeftCrosshairGraphic());
        }
    }
}

