/*
$RCSfile: countResultAlgorithms.js $
$Revision: 1452 $

last change: $Date: 2010-02-10 21:01:39 +0300 (Ср, 10 фев 2010) $
             $Author: Pavel $

	Lacerta Project
	version 1.0.0.6
	Copyright (C) 2007-2010 RNMC
*/

/*
==============================================================================
||									    ()	||
==============================================================================
||		||						 							||
==============================================================================
|| none			||   									||
==============================================================================
|| discrete		||       (100%) 			||
||				||     (0%).								||
||				|| N = n,  R = 100%,  R = 0%							||
==============================================================================
|| smooth		|| n/(N+h)*100%												||
==============================================================================
|| smooth_err	|| n/(N+k+h)*100%											||
==============================================================================
|| attempts		||  n=N  N/(P+h)*100%	  				||
==============================================================================
|| repeat		|| n/(n+k*P+h)*100%											||
==============================================================================
||				||															||
==============================================================================

  "results":
objectResult		 -    
rightElements		-     (n)
allRightElements -        (N)
wrongElements		-     (k)
totalTime				-       
									 ( )
elapsedTime			-    
									 ( )
isTimeout				-    
helpsCount			 -   (h)
checksCount		 -   (P)

:

		var results;
		results = new scene.Utils.resultParam();
		results.init();
		
		results.rightElements = rightSelected;
		results.allRightElements = rightRelations;
		results.wrongElements = wrongSelected;		
		
		results.countResult(this.crAlgorithm);
		
		this.currentResult = results.objectResult;
*/

function resultParam(){

	resultParam.prototype.init = function(){
		this.objectResult = 0;
		this.rightElements = 0;
		this.allRightElements = 0;
		this.wrongElements = 0;
		this.totalTime = 0;
		this.elapsedTime = 0;
		this.isTimeout = false;
	this.helpsCount = 0;
	this.checksCount = 0;
	}
	
	resultParam.prototype.countResult = function(crAlgorithm){
		trace("crAlgorithm = " + crAlgorithm)
	trace("rightElements (n) = " +	this.rightElements)
	trace("allRightElements (N) = " + this.allRightElements)
	trace("wrongElements (k) = " + this.wrongElements)
	trace("checksCount (P) = " + this.checksCount)
	trace("helpsCount (h) = " + this.helpsCount)
	try{
		switch(crAlgorithm.toLowerCase()){
				case "discrete":
					CR_DISCRETE(this);
					break;
				case "smooth":
					CR_SMOOTH(this);
					break;
				case "smooth_err":
					CR_SMOOTH_ERR(this);
					break;
				case "attempts":
					CR_ATTEMPTS(this);
					break;
			case "repeat":
					CR_REPEAT(this);
					break;
		default:
			CR_NO(this);
	 	 }
	} catch(e){
		trace("#FF0000Error in counting results: " + e);
	}
	if(isNaN(this.objectResult))
		this.objectResult = 0;
	trace("===============================")
	trace("objectResult = " + this.objectResult)
	}
}

function CR_REPEAT(results){	
		results.objectResult =
		Math.round((results.rightElements / (results.allRightElements + results.wrongElements * results.checksCount + results.helpsCount))*100);	
}

function CR_NO(results){
	results.objectResult = 0;
	trace(":      ( = 0)");
}

function CR_DISCRETE(results){
	results.objectResult =
	(results.rightElements == results.allRightElements) ? 100 : 0;
}

function CR_SMOOTH(results){
	results.objectResult =
	Math.round((results.rightElements / (results.allRightElements + results.helpsCount)) * 100);
}

function CR_SMOOTH_ERR(results){
	results.objectResult =
	Math.round((results.rightElements / (results.allRightElements + results.wrongElements + results.helpsCount))*100);
}

function CR_ATTEMPTS(results){
	if (results.allRightElements == results.rightElements)
		results.objectResult = Math.round((results.allRightElements / (results.checksCount + results.helpsCount)) * 100);
	else
		results.objectResult = 0;

	if (results.objectResult > 100)
		results.objectResult = 100;
}