	function stepsResult(){
		//	 
		this.exportColumnName = true;
		this.exportColumnStartTime = true;
		this.exportColumnDuration = true;
		this.exportColumnErrors = true;
		this.exportColumnHelps = true;
		this.exportColumnResult = true;

		//	    
		this.labworkResultCount = false;
	
		//	      ,   
		this.stepResults = new Array();
	
		//     
		this.currentStep = null;
		this.currentAttempt = null;

	//	    
	//	SELECT_RESULT_LAST = 0;			-	
	//	SELECT_RESULT_BEST = 1;			-	
	//	SELECT_RESULT_AVERAGE = 2;		-	
		this.defaultResultSelectRule = SELECT_RESULT_LAST;
	}
	
	stepsResult.prototype.setManuallyOperated = function(theParam){
		//          
		if(theParam == "true")
			this.stepResults[this.currentStep][this.currentAttempt].manually = true
		else
			this.stepResults[this.currentStep][this.currentAttempt].manually = false;
	}
	
	stepsResult.prototype.setSceneComplete = function(theParam){
		//        (    .manually = true;)
		if(theParam == "false")
			this.stepResults[this.currentStep][this.currentAttempt].sceneCompleted = false
		else if(theParam == "true")
			this.stepResults[this.currentStep][this.currentAttempt].sceneCompleted = true;
	}	
	
	stepsResult.prototype.getSceneComplete = function(stepIndex){
		if(!this.stepResults[stepIndex])
			return false;

		for(var i = 0; i < this.stepResults[stepIndex].length; i++){
			if (this.stepResults[stepIndex][i].manually){
				if (this.stepResults[stepIndex][i].sceneCompleted)
					return true;
			} else
				return true;
		}
		return false;
	}

	//	 
	stepsResult.prototype.addStep = function(stepName, stepType, stepResultCount, 
								resultSelectRule, stepComplexity, stepId, stepIndex){
		this.stepResults[stepIndex] = new Array();
		//  
		this.stepResults[stepIndex].stepName = stepName;
		//   ( )
		this.stepResults[stepIndex].stepType = stepType;
		//   (  1)
		this.stepResults[stepIndex].stepComplexity = stepComplexity;
		this.stepResults[stepIndex].stepId = stepId;
		if(stepResultCount)
			this.labworkResultCount = true;
		//      
		this.stepResults[stepIndex].stepResultCount = stepResultCount;
		if(resultSelectRule != undefined && resultSelectRule != null)
			this.stepResults[stepIndex].stepResultSelectRule = resultSelectRule
		else
			this.stepResults[stepIndex].stepResultSelectRule = this.defaultResultSelectRule;		
		this.stepResults[stepIndex].stepVisited = false;
		//	  
		this.stepResults[stepIndex].stepAttemptsState = scene.Labwork.langStrings.getValue("result_not_served");
	}

	//         stepId
	stepsResult.prototype.onStartStep = function(stepIndex){
		//    
		this.currentStep = stepIndex;
		this.stepResults[stepIndex].stepVisited = true;
		//    
		this.currentAttempt = this.stepResults[stepIndex].length - 1;
		if(this.currentAttempt < 0){
			this.currentAttempt = 0;
			this.stepResults[stepIndex][this.currentAttempt] = new Object();
		}
		var startDate = new Date();
		//     
		this.stepResults[stepIndex][this.currentAttempt].stepAttemptStart = startDate.getHours()*3600 + startDate.getMinutes()*60 + startDate.getSeconds();
		this.stepResults[stepIndex][this.currentAttempt].stepAttemptDuration = 0;
		this.stepResults[stepIndex][this.currentAttempt].stepAttemptErrors = 0;
		this.stepResults[stepIndex][this.currentAttempt].manually = false;
		this.stepResults[stepIndex][this.currentAttempt].sceneCompleted = false;
		
		this.stepResults[stepIndex].stepAttemptsState = scene.Labwork.langStrings.getValue("result_served");
	}

	//      
	stepsResult.prototype.onFinishStep = function(curAttemptResult, curAttemptErrors, curAttemptHelps, curAttempts){
		//      ,   != summary
		if(this.stepResults[this.currentStep].stepType != "summary"){
			var finishDate = new Date();
			var stepAttemptDuration = Math.round((finishDate.getHours()*3600 + finishDate.getMinutes()*60 + finishDate.getSeconds()) - this.stepResults[this.currentStep][this.currentAttempt].stepAttemptStart + 0.5);
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptDuration = stepAttemptDuration;
		} else
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptDuration = 0;
		if(curAttemptErrors)
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptErrors += curAttemptErrors;
		if(curAttemptHelps){
			var arrayOfId = this.stepResults[this.currentStep][this.currentAttempt].stepAttemptHelps;
			var currentHelps = scene.Utils.getObjectPropertyLength(arrayOfId);
			currentHelps += curAttemptHelps;
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptHelps = currentHelps;
		}

		//	  ,   
		if(curAttemptResult){
		//	  
			var newResult = 0;
			if(curAttemptResult.length > 0){
				var totalCoefficient = 0;
				var normalizedCoefficient = 0;
				for(var i = 0; i < curAttemptResult.length; i++){
					var objectStat = curAttemptResult[i].split(";");
					var objectResult = parseInt(objectStat[0]);
					var objectWeight = parseFloat(objectStat[1]);
					totalCoefficient += objectWeight;
				}
			//      
				var arrayOfId = this.stepResults[this.currentStep][this.currentAttempt].stepAttemptHelps;
				var currentHelps = scene.Utils.getObjectPropertyLength(arrayOfId);
				normalizedCoefficient = 1/(totalCoefficient/*+currentHelps*/);
				for(var i = 0; i < curAttemptResult.length; i++){
					var objectStat = curAttemptResult[i].split(";");
					var objectResult = parseInt(objectStat[0]);
					var objectWeight = parseFloat(objectStat[1]);
					newResult += objectWeight*objectResult*normalizedCoefficient;
				}
			} else
				newResult = 100;

					newResult = Math.round(newResult);
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptResult = parseInt(newResult);
		} else
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptResult = 0;
			
		//	        setProperty
		if("result" in scene.Labwork.currentStep)
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptResult = scene.Labwork.currentStep.result;
		if("errors" in scene.Labwork.currentStep)
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptErrors = scene.Labwork.currentStep.errors;
		if("helps" in scene.Labwork.currentStep)
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptHelps = scene.Labwork.currentStep.helps;
		if("CMI_completion_status" in scene.Labwork.currentStep)
			this.stepResults[this.currentStep].CMI_completion_status = scene.Labwork.currentStep.CMI_completion_status;
		if("CMI_success_status" in scene.Labwork.currentStep)
			this.stepResults[this.currentStep].CMI_success_status = scene.Labwork.currentStep.CMI_success_status;
		if("CMI_progress_measure" in scene.Labwork.currentStep)
			this.stepResults[this.currentStep].CMI_progress_measure = scene.Labwork.currentStep.CMI_progress_measure;
		if("CMI_completion_threshold" in scene.Labwork.currentStep)
			this.stepResults[this.currentStep].CMI_completion_threshold = scene.Labwork.currentStep.CMI_completion_threshold;
		if("CMI_scaled_passing_score" in scene.Labwork.currentStep)
			this.stepResults[this.currentStep].CMI_scaled_passing_score = scene.Labwork.currentStep.CMI_scaled_passing_score;
	}

//	==================================================================================
//	    
//	==================================================================================

	//	 
	stepsResult.prototype.getStepName = function(stepIndex){
		return this.stepResults[stepIndex].stepName;
	}

	//	 
	stepsResult.prototype.getStepType = function(stepIndex){
		return this.stepResults[stepIndex].stepType;
	}

	//	   
	stepsResult.prototype.getStepVisited = function(stepIndex){
		return this.stepResults[stepIndex].stepVisited;
	}
	
	stepsResult.prototype.getStepVisitedEx = function(stepIndex){
		var sv = "";
		if (this.stepResults[stepIndex].stepResultCount)
			sv = this.stepResults[stepIndex].stepAttemptsState;
		return sv;
	}

	//	      
	stepsResult.prototype.getStepResultCount = function(stepIndex){
		return this.stepResults[stepIndex].stepResultCount;
	}

	//	    
	stepsResult.prototype.getStepStartTime = function(stepIndex){
		//            
		if(this.stepResults[stepIndex].length > 0)
			return this.stepResults[stepIndex][0].stepAttemptStart
		else
			return -1;
	}

	//	   
	stepsResult.prototype.getStepDuration = function(stepIndex){
		var totalDuration = 0;
		for(var i = 0; i < this.stepResults[stepIndex].length; i++)
			totalDuration += this.stepResults[stepIndex][i].stepAttemptDuration;
		return totalDuration;
	}


	//	   
	stepsResult.prototype.getStepErrors = function(stepIndex){
		var totalErrors = 0;

			if(this.stepResults[stepIndex].stepResultCount){
			switch(this.stepResults[stepIndex].stepResultSelectRule){
				case SELECT_RESULT_LAST:
					if(this.stepResults[stepIndex].length > 0){
						var attemptIndex = this.stepResults[stepIndex].length;						
						if(this.stepResults[stepIndex][attemptIndex-1].manually == true &&
						this.stepResults[stepIndex][attemptIndex-1].sceneCompleted == false)
							totalErrors = 0
						else
							totalErrors = this.stepResults[stepIndex][attemptIndex-1].stepAttemptErrors;
					} else
						totalErrors = 0;
					break;
				case SELECT_RESULT_BEST:
					totalErrors = 0;
					var bestResult = 0;
					for(var i = 0; i < this.stepResults[stepIndex].length; i++){
						if(this.stepResults[stepIndex][i].manually == true &&
						this.stepResults[stepIndex][i].sceneCompleted == false)
							continue;
						
						if(this.stepResults[stepIndex][i].stepAttemptResult > bestResult){
							bestResult = this.stepResults[stepIndex][i].stepAttemptResult;
											totalErrors = this.stepResults[stepIndex][i].stepAttemptErrors;
						}
					}
					break;
				case SELECT_RESULT_AVERAGE:
					var attemptsCount = 0;
					for(var i = 0; i < this.stepResults[stepIndex].length; i++){
						if(this.stepResults[stepIndex][i].manually == true &&
						this.stepResults[stepIndex][i].sceneCompleted == false)
							continue;
						
						totalErrors += this.stepResults[stepIndex][i].stepAttemptErrors;
						attemptsCount++;
					}
					if(attemptsCount > 0)
						totalErrors = Math.round(totalErrors/attemptsCount)
					else
						totalErrors = 0;
			}
			} else
				totalErrors = -1;

		return totalErrors;
	}
	
	//        
	stepsResult.prototype.getCurrentStepHelps = function(){
		var arrayOfId = this.stepResults[this.currentStep][this.currentAttempt].stepAttemptHelps;
		var helpsCount = scene.Utils.getObjectPropertyLength(arrayOfId);
		return helpsCount;
	}
	//    
	stepsResult.prototype.getCurrentStep = function(){
		return this.currentStep;
	}
	
	//	   
	stepsResult.prototype.getStepHelps = function(stepIndex){
		var totalHelps = 0;	
			if(this.stepResults[stepIndex].stepResultCount){
			switch(this.stepResults[stepIndex].stepResultSelectRule){
				case SELECT_RESULT_LAST:
					if(this.stepResults[stepIndex].length > 0){				
						var attemptIndex = this.stepResults[stepIndex].length;						
						if(this.stepResults[stepIndex][attemptIndex-1].manually == true &&
						this.stepResults[stepIndex][attemptIndex-1].sceneCompleted == false)
							totalHelps = 0
						else{
							var arrayOfId = this.stepResults[stepIndex][attemptIndex-1].stepAttemptHelps;
							totalHelps = scene.Utils.getObjectPropertyLength(arrayOfId);
						}
					} else
						totalHelps = 0;
					break;
				case SELECT_RESULT_BEST:
					totalHelps = 0;
					var bestResult = 0;
					for(var i = 0; i < this.stepResults[stepIndex].length; i++){
						if(this.stepResults[stepIndex][i].manually == true &&
						this.stepResults[stepIndex][i].sceneCompleted == false)
							continue;
							
						if(this.stepResults[stepIndex][i].stepAttemptResult > bestResult){
							bestResult = this.stepResults[stepIndex][i].stepAttemptResult;
							var arrayOfId = this.stepResults[stepIndex][i].stepAttemptHelps;
							totalHelps = scene.Utils.getObjectPropertyLength(arrayOfId);
						}
					}
					break;
				case SELECT_RESULT_AVERAGE:
					var attemptsCount = 0;
					for(var i = 0; i < this.stepResults[stepIndex].length; i++){
						if(this.stepResults[stepIndex][i].manually == true &&
						this.stepResults[stepIndex][i].sceneCompleted == false)
							continue;
						
						var arrayOfId = this.stepResults[stepIndex][i].stepAttemptHelps;
						totalHelps += scene.Utils.getObjectPropertyLength(arrayOfId);
						attemptsCount++;
					}
					if(attemptsCount > 0)
						totalHelps = Math.round(totalHelps/attemptsCount)
					else
						totalHelps = 0;
			}
			} else
				totalHelps = -1;
			
		return totalHelps;
	}

	//	   
	stepsResult.prototype.getStepAttempts = function(stepIndex){
		var totalAttempts = 0;
		if(this.stepResults[stepIndex].stepResultCount)
			totalAttempts = this.stepResults[stepIndex].length
		else
			totalAttempts = -1;
		
		return totalAttempts;
	}
	
	stepsResult.prototype.getStepCoefficient = function(stepIndex){	
		if(this.stepResults[stepIndex].stepResultCount)
			return this.stepResults[stepIndex].stepComplexity;
		return "";
	}

	//	  
	stepsResult.prototype.getStepResult = function(stepIndex){
		var newStepResult = 0;
		if(this.stepResults[stepIndex].stepType == "summary")
			return 0;
		
		if(this.stepResults[stepIndex].stepResultCount){
			switch(this.stepResults[stepIndex].stepResultSelectRule){
			case SELECT_RESULT_LAST:
				if(this.stepResults[stepIndex].length > 0){
					var attemptIndex = this.stepResults[stepIndex].length;
					if(this.stepResults[stepIndex][attemptIndex-1].manually == true &&
					this.stepResults[stepIndex][attemptIndex-1].sceneCompleted == false)
						newStepResult = 0
					else
						newStepResult = this.stepResults[stepIndex][attemptIndex-1].stepAttemptResult;
				} else
					newStepResult = 0;
				break;				
			case SELECT_RESULT_BEST:
				newStepResult = 0;
				for(var i = 0; i < this.stepResults[stepIndex].length; i++){
					if(this.stepResults[stepIndex][i].manually == true &&
					this.stepResults[stepIndex][i].sceneCompleted == false)
						continue;
					if(this.stepResults[stepIndex][i].stepAttemptResult > newStepResult)
						newStepResult = this.stepResults[stepIndex][i].stepAttemptResult;
				}
				break;
			case SELECT_RESULT_AVERAGE:
				newStepResult = 0;
				var attemptsCount = 0;
				for(var i = 0; i < this.stepResults[stepIndex].length; i++){
					if(this.stepResults[stepIndex][i].manually == true &&
					this.stepResults[stepIndex][i].sceneCompleted == false)
						continue;
					newStepResult += this.stepResults[stepIndex][i].stepAttemptResult;
					attemptsCount++;
				}
				if(attemptsCount > 0)
					newStepResult = Math.round(newStepResult/attemptsCount);
			}
		} else
			newStepResult = -1;
		
		return newStepResult;
	}
 
	stepsResult.prototype.getSelectRule = function(stepIndex){
		var str_ret = "";
		if(this.stepResults[stepIndex].stepResultCount){
			switch(this.stepResults[stepIndex].stepResultSelectRule){
			case SELECT_RESULT_LAST:
				str_ret = scene.Labwork.langStrings.getValue("result_rule_last");
				break;
			case SELECT_RESULT_BEST:
				str_ret = scene.Labwork.langStrings.getValue("result_rule_best");
				break;
			case SELECT_RESULT_AVERAGE:
				str_ret = scene.Labwork.langStrings.getValue("result_rule_average");
			}
		}
		return str_ret;
	}

//	===============================================================================
//	     
//	===============================================================================

	//	  
	stepsResult.prototype.getStepsTotal = function(){
		return this.stepResults.length;
	}

	//	   
	stepsResult.prototype.getTotalDuration = function(){
		var totalDuration = 0;
		for(var i = 0; i < this.stepResults.length; i++)
			for(var j = 0; j < this.stepResults[i].length; j++)
				totalDuration += this.stepResults[i][j].stepAttemptDuration;
		return totalDuration;
	}

	//	    
	stepsResult.prototype.getTotalErrors = function(){
		var totalErrors = 0;
		for(var i = 0; i < this.stepResults.length; i++)
			if(this.stepResults[i].stepResultCount)
				for(var j = 0; j < this.stepResults[i].length; j++){
					if(this.stepResults[i][j].manually == true &&
					this.stepResults[i][j].sceneCompleted == false)
						continue;
			
					totalErrors += this.stepResults[i][j].stepAttemptErrors;
				}
		return totalErrors;
	}

	//	    
	stepsResult.prototype.getTotalHelps = function(){
		var totalHelps = 0;
		for(var i = 0; i < this.stepResults.length; i++)
			if(this.stepResults[i].stepResultCount)
				for(var j = 0; j < this.stepResults[i].length; j++){
					if(this.stepResults[i][j].manually == true &&
					this.stepResults[i][j].sceneCompleted == false)
						continue;
					
					var arrayOfId = this.stepResults[i][j].stepAttemptHelps;
					totalHelps += scene.Utils.getObjectPropertyLength(arrayOfId);
				}
		return totalHelps;
	}

	//	    
	//	   (T)
	stepsResult.prototype.getTotalAttempts = function(){
		var totalAttempts = 0;
		for(var i = 0; i < this.stepResults.length; i++)
			if(this.stepResults[i].stepType != "summary" && this.stepResults[i].stepResultCount)
				totalAttempts += this.stepResults[i].length;
		return totalAttempts;
	}

	//	      (  )
	stepsResult.prototype.getTotalResult = function(){
		var stepsTotal = this.stepResults.length;
		var stepsCount = 0;
		var percent =	0;
		var sumUp = 0, sumDown = 0;

		for(var i = 0; i < stepsTotal; i++){
			if(this.stepResults[i].stepType == "summary" || !this.stepResults[i].stepResultCount)
				continue;
						
			stepsCount++;
			var newStepRes = this.getStepResult(i);
			percent += newStepRes;
			sumUp += newStepRes * this.stepResults[i].stepComplexity;
			sumDown += this.stepResults[i].stepComplexity;
		}
		return Math.round(sumUp/sumDown);
	}
	
	stepsResult.prototype.setCurrentStepStatus = function(key_str){
		this.stepResults[this.currentStep].stepAttemptsState = scene.Labwork.langStrings.getValue(key_str);
	}
	
	//	     
	stepsResult.prototype.saveResultsToFile = function(targetFile){
		var headerString	= "";
		var footerString	= "";
		var oddItemString	= "";
		var evenItemString	= "";
		var summaryItemString	= "";
		var defaultItemString = "";
		var exportSettingsXML = new XML();

		var textResult = new Text();
		textResult.visible = false;
		textResult.parent = parent;

		var settingsSrc = scene.result_export_xml;

		if(!resourceExists(settingsSrc)){
			//	FOR COMPATIBILITY
			//	,     (  HTML   )
			textResult.value = "<html><body><center><table border=\"1\"><tr><td align=\"center\"> </td><td align=\"center\">  </td><td align=\"center\"> </td><td align=\"center\">/</td><td align=\"center\"> </td></tr>"
			var totalSteps = this.getStepsTotal();
			for(var i = 0; i	< totalSteps; i++){
				var stepName = (i + 1) + ".	" + this.getStepName(i);
				var stepStartTime = scene.Utils.translateSecondsToString(this.getStepStartTime(i), true);
				var stepDuration = scene.Utils.translateSecondsToString(this.getStepDuration(i), true);
				var stepErrorsHelps = this.getStepErrors(i) + " / " + this.getStepHelps(i);
				var stepResult = "";
				if(this.getStepVisited(i)){
					stepResult = "";
				} else {
					stepResult = " ";
				}
				var newStepInfo = "<tr><td>" + stepName + "</td><td align=\"center\">" + stepStartTime + "</td><td align=\"center\">" + stepDuration + "</td><td align=\"center\">" + stepErrorsHelps + "</td><td align=\"center\">" + stepResult + "</td></tr>";
				textResult.value = textResult.value + newStepInfo;
			}
			//	 
			var stepName = " ";
			var stepStartTime = "";
			var stepDuration = scene.Utils.translateSecondsToString(this.getTotalDuration(), true);
			var stepErrorsHelps = this.getTotalErrors() + " / " + this.getTotalHelps();
			var stepResult = "";
			var newStepInfo = "<tr><td>" + stepName + "</td><td align=\"center\">" + stepStartTime + "</td><td align=\"center\">" + stepDuration + "</td><td align=\"center\">" + stepErrorsHelps + "</td><td align=\"center\">" + stepResult + "</td></tr>";
			textResult.value = textResult.value + newStepInfo;
			textResult.saveAs("result.htm");
			textResult.parent = null;
		
			return false;
		}
		exportSettingsXML.src = settingsSrc;
		if (!exportSettingsXML.XMLDocument){
			return false;
		} else {
			exportSettingsXML.XMLDocument.source = exportSettingsXML.src;
			xmlNode = exportSettingsXML.XMLDocument.firstChild.firstChild;
			while(xmlNode){	
				if(xmlNode.nodeName == "header" && xmlNode.textContent){
					headerString = xmlNode.textContent;
				} else if(xmlNode.nodeName == "step" && xmlNode.textContent){
					xmlAttributeMap = xmlNode.attributes;
					if (xmlAttributeMap){
						xmlAttribute = xmlAttributeMap.getNamedItem("index");
						if (xmlAttribute != null && xmlAttribute.specified){
							switch((xmlAttribute.value).toLowerCase()){
							case "even":
								evenItemString	= xmlNode.textContent;	
								break;
							case "odd":
								oddItemString	= xmlNode.textContent;
								break;
							case "summary":
								summaryItemString	= xmlNode.textContent;
							}
						} else
							defaultItemString = xmlNode.textContent;
					}
				} else if(xmlNode.nodeName == "footer" && xmlNode.textContent)
					footerString = xmlNode.textContent;
				xmlNode = xmlNode.nextSibling;
			}
			textResult.value = headerString;

			var totalSteps = this.getStepsTotal();
			for(var i = 0; i	< totalSteps; i++){
				if(this.stepResults[i].stepType == "summary"){
					continue;
				}
				var srcItemStr = "";
				if(evenItemString && oddItemString){
					if(((i + 1) % 2) == 0){
						srcItemStr = "\n" + evenItemString;
					} else {
						srcItemStr = "\n" + oddItemString;
					}
				} else {
					srcItemStr = defaultItemString;
				}
				var re = new RegExp("(%StepIndex%)", "g");
				srcItemStr = srcItemStr.replace(re, (i+1));
				re = null;
				re = new RegExp("(%StepName%)", "g");
				srcItemStr = srcItemStr.replace(re, this.getStepName(i));
				re = null;
				var re = new RegExp("(%StartTime%)", "g");
				srcItemStr = srcItemStr.replace(re, scene.Utils.translateSecondsToString(this.getStepStartTime(i), true));
				re = null;
				var re = new RegExp("(%Duration%)", "g");
				srcItemStr = srcItemStr.replace(re, scene.Utils.translateSecondsToString(this.getStepDuration(i), true));
				re = null;
				var re = new RegExp("(%Errors%)", "g");
				if(this.getStepErrors(i) == -1)
					srcItemStr = srcItemStr.replace(re, "");
				else
					srcItemStr = srcItemStr.replace(re, this.getStepErrors(i));
				re = null;
				var re = new RegExp("(%Helps%)", "g");
				if(this.getStepErrors(i) == -1)
					srcItemStr = srcItemStr.replace(re, "");
				else
					srcItemStr = srcItemStr.replace(re, this.getStepHelps(i));
				re = null;
				var re = new RegExp("(%Attempts%)", "g");
				if(this.getStepErrors(i) == -1)
					srcItemStr = srcItemStr.replace(re, "");
				else
					srcItemStr = srcItemStr.replace(re, this.getStepAttempts(i));
				re = null;
				var re = new RegExp("(%Result%)", "g");
				if(this.getStepErrors(i) == -1)
					srcItemStr = srcItemStr.replace(re, "");
				else
					srcItemStr = srcItemStr.replace(re, this.getStepResult(i));
				re = null;
				var re = new RegExp("(%State%)", "g");
				srcItemStr = srcItemStr.replace(re, this.getStepVisitedEx(i));
				re = null;
				var re = new RegExp("(%Coefficient%)", "g");
				srcItemStr = srcItemStr.replace(re, this.getStepCoefficient(i));
				re = null;
				var re = new RegExp("(%SelectRule%)", "g");
				srcItemStr = srcItemStr.replace(re, this.getSelectRule(i));
				re = null;
				textResult.value = textResult.value + srcItemStr;
			}
			if(summaryItemString){
				//	 
				if(summaryItemString){
					srcItemStr = "\n" + summaryItemString;
				} else {
					srcItemStr = defaultItemString;
				}
				var re = null;
				re = new RegExp("(%StepIndex%)", "g");
				srcItemStr = srcItemStr.replace(re, "");
				re = null;
				re = new RegExp("(%StepName%)", "g");
				srcItemStr = srcItemStr.replace(re, " ");
				re = null;
				var re = new RegExp("(%StartTime%)", "g");
				srcItemStr = srcItemStr.replace(re, scene.Utils.translateSecondsToString(this.getStepStartTime(0), true));
				re = null;
				var re = new RegExp("(%Duration%)", "g");
				srcItemStr = srcItemStr.replace(re, scene.Utils.translateSecondsToString(this.getTotalDuration(), true));
				re = null;
				var re = new RegExp("(%Errors%)", "g");
				srcItemStr = srcItemStr.replace(re, this.getTotalErrors());
				re = null;
				var re = new RegExp("(%Helps%)", "g");
				srcItemStr = srcItemStr.replace(re, this.getTotalHelps());
				re = null;
				var re = new RegExp("(%Attempts%)", "g");
				srcItemStr = srcItemStr.replace(re, this.getTotalAttempts());
				re = null;
				var re = new RegExp("(%Result%)", "g");
				srcItemStr = srcItemStr.replace(re, this.getTotalResult());
				re = null;
				var re = new RegExp("(%State%)", "g");
				srcItemStr = srcItemStr.replace(re, "");
				re = null;
				var re = new RegExp("(%Coefficient%)", "g");
				srcItemStr = srcItemStr.replace(re, "");
				re = null;
				var re = new RegExp("(%SelectRule%)", "g");
				srcItemStr = srcItemStr.replace(re, "");
				re = null;
				textResult.value = textResult.value + srcItemStr;
			}
		}
		textResult.value = textResult.value + footerString;
		textResult.saveAs("result.htm");
		textResult.parent = null;
	}

	stepsResult.prototype.addErrors = function(errorsIncrement){
		var currentErrors = this.stepResults[this.currentStep][this.currentAttempt].stepAttemptErrors;
		currentErrors += errorsIncrement;
		if(currentErrors >= 0)
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptErrors = currentErrors
		else{
			trace("#FF0000   .      0.");
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptErrors = 0;
		}
	}
	

	stepsResult.prototype.addHelps = function(helpsIncrement, theId){
		//          
		//   "noId" 
		var currentPropArrey = this.stepResults[this.currentStep][this.currentAttempt].stepAttemptHelps;
		if(theId == undefined)
			theId = "noId";
		if(!(theId in currentPropArrey))
			currentPropArrey[theId] = 0;
		var currentHelps =	currentPropArrey[theId];
		currentHelps += helpsIncrement;
		if(currentHelps >= 0){
			currentPropArrey[theId] = currentHelps;
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptHelps = currentPropArrey;
		} else{
			trace("#FF0000   .      0.");
			currentPropArrey[theId] = 0;
			this.stepResults[this.currentStep][this.currentAttempt].stepAttemptHelps = currentPropArrey[theId];
		}
	}

	stepsResult.prototype.updateStatistics = function(newResult, newErrors, newHelps, newAttempts){
		if(parent.localStepIndicator){
			parent.localStepIndicator.onResultManagerEventOccuried(ON_STEP_RESULT_CHANGED,		newResult);
			parent.localStepIndicator.onResultManagerEventOccuried(ON_STEP_ERRORS_CHANGED,		newErrors);
			parent.localStepIndicator.onResultManagerEventOccuried(ON_STEP_HELPS_CHANGED,		newHelps);
			parent.localStepIndicator.onResultManagerEventOccuried(ON_STEP_ATTEMPTS_CHANGED, newAttempts);
		}
	}

	stepsResult.prototype.traceStepStatistics = function(){
		var stepsTotal = this.stepResults.length;
		for(var i = 0; i < stepsTotal; i++){
			trace(i + ": " + this.stepResults[i].stepName);
			trace("\t : " + this.stepResults[i].stepType);
			trace("\t: " + this.stepResults[i].stepVisited);
			trace("\t: " + this.stepResults[i].length);
			switch(this.stepResults[i].stepResultSelectRule){
			case SELECT_RESULT_LAST:
				trace("\t  : ");
				break;
			case SELECT_RESULT_BEST:
				trace("\t  : ");
				break;
			case SELECT_RESULT_AVERAGE:
				trace("\t  : ");
			}
			trace("\t: " + this.getStepResult(i));
		}
}