/*
$RCSfile: countResultAlgorithms.mjs,v $
$Revision: 1099 $

last change: $Date: 2009-05-19 17:28:46 +0400 (Вт, 19 май 2009) $
             $Author: Pavel $

  Lacerta Project
  version 1.0.0.4
  Copyright (C) 2007-2009 RNMC
*/

/*
===============================================================================
||                      ()                    ||
===============================================================================
||          ||                                               ||
===============================================================================
|| none             ||                                   ||
===============================================================================
|| discrete         ||       (100%)       ||
||                  ||     (0%)                            ||
===============================================================================
|| smooth           || n/N*100%                                              ||
===============================================================================
|| smooth_err       || n/(N+k)*100%                                          ||
===============================================================================
|| attempts         || N/M*100%                                              ||
===============================================================================
||                  ||                                                       ||
===============================================================================
||                  ||                                                       ||
===============================================================================

  "results":
objectResult     -    
attemptsCount    -   ( ,   
                   )(M)     
allElements      -       (N+) (P) "unknown"
rightElements    -     (n)
allRightElements -      (N)
wrongElements    -     (k)
allWrongElements -      (K)
message          -      
                   ,    
                   true / false
totalTime        -       
                   ( )
elapsedTime      -    
                   ( )
taskIsLost       -     ()
                   true / false
isTimeout        -    

:

    var results;
    results = new scene.Utils.resultParam();
    results.init();
    
    results.rightElements = rightSelected;
    results.allRightElements = rightRelations;
    results.wrongElements = wrongSelected;
    results.allWrongElements = totalAnswers - rightRelations;
    results.allElements = results.allRightElements + results.allWrongElements  "unknown";
    results.isTimeout = this.isOnTimeout;
    
    results.countResult(this.crAlgorithm);
    
    this.currentResult = results.objectResult;
    
...
    //for (var key in results)
      //trace("#FF0000results."+key+" = "+results[key]);
*/

function resultParam(){

  resultParam.prototype.init = function(){
    this.objectResult = 0;
    this.attemptsCount = 0;
    this.allElements = 0;
    this.rightElements = 0;
    this.allRightElements = 0;
    this.wrongElements = 0;
    this.allWrongElements = 0;
    this.message = false;
    this.totalTime = 0;
    this.elapsedTime = 0;
    this.taskIsLost = false;
    this.isTimeout = false;
  }
  
  resultParam.prototype.countResult = function(crAlgorithm){
    this.message = false;
    switch(crAlgorithm.toLowerCase()){
      case "none":
        CR_NO(this);
        break;
      case "discrete":
        CR_DISCRETE(this);
        break;
      case "smooth":
        CR_SMOOTH(this);
        break;
      case "smooth_err":
        CR_SMOOTH_ERR(this);
        break;
      case "attempts":
        CR_ATTEMPTS(this);
        break;
    }
  }
}

function CR_NO(results){
  results.objectResult = 0;
}

function CR_DISCRETE(results){
  results.objectResult = 
	(results.rightElements == results.allRightElements && results.wrongElements == 0) ? 100 : 0;
}

function CR_SMOOTH(results){
  results.objectResult = results.rightElements / results.allRightElements * 100;
}

function CR_SMOOTH_ERR(results){
  if("unknown" != results.allElements && 
     (results.rightElements + results.wrongElements) == results.allElements){
    results.objectResult = 0;
    results.message = true
  }else{
    results.objectResult = Math.round(results.rightElements/(results.allRightElements+results.wrongElements)*100);
//      results.objectResult = Math.round((results.rightElements - results.wrongElements + results.allWrongElements) / results.allElements * 100);
    
    if(results.objectResult < 0){
      results.objectResult = 0;
    }
  }
}

function CR_ATTEMPTS(results){
  if (results.attemptsCount)
    results.objectResult = results.rightElements / results.attemptsCount * 100;
  else
    results.objectResult = results.rightElements / 1 * 100;
}