/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PDimension;

public class PDragEventHandler
extends PDragSequenceEventHandler {
    private PNode draggedNode = null;
    private boolean moveToFrontOnPress = false;

    public PDragEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    protected boolean shouldStartDragInteraction(PInputEvent pInputEvent) {
        return super.shouldStartDragInteraction(pInputEvent) && pInputEvent.getPickedNode() != pInputEvent.getTopCamera();
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        this.draggedNode = pInputEvent.getPickedNode();
        if (this.moveToFrontOnPress) {
            this.draggedNode.moveToFront();
        }
    }

    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        PDimension pDimension = pInputEvent.getDeltaRelativeTo(this.draggedNode);
        this.draggedNode.localToParent(pDimension);
        this.draggedNode.offset(pDimension.getWidth(), pDimension.getHeight());
    }

    protected void endDrag(PInputEvent pInputEvent) {
        super.endDrag(pInputEvent);
        this.draggedNode = null;
    }
}

