/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.view;

import edu.colorado.phet.common.charts.GridLineSet;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.charts.ScatterPlot;
import edu.colorado.phet.photoelectric.PhotoelectricConfig;
import edu.colorado.phet.photoelectric.model.PhotoelectricModel;
import edu.colorado.phet.photoelectric.model.util.PhotoelectricModelUtil;
import edu.colorado.phet.photoelectric.view.PhotoelectricGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.RenderingHints;

public class CurrentVsIntensityGraph
extends PhotoelectricGraph {
    private static Range2D range = new Range2D(0.0, 0.0, PhotoelectricModel.MAX_PHOTONS_PER_SECOND, PhotoelectricModel.MAX_CURRENT);
    private static Dimension chartSize = PhotoelectricConfig.CHART_SIZE;
    private static double PLOT_LAYER = 1.0E9;

    public CurrentVsIntensityGraph(Component component, final PhotoelectricModel photoelectricModel) {
        super(component, range, chartSize, 50.0, 100.0, PhotoelectricModel.MAX_CURRENT / 6.0, PhotoelectricModel.MAX_CURRENT / 6.0);
        GridLineSet gridLineSet = this.getHorizonalGridlines();
        gridLineSet.setMajorGridlinesColor(new Color(200, 200, 200));
        GridLineSet gridLineSet2 = this.getVerticalGridlines();
        gridLineSet2.setMajorGridlinesColor(new Color(200, 200, 200));
        Color color = new Color(0, 180, 0);
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 80);
        LinePlot linePlot = new LinePlot(this.getComponent(), this, this.getLineDataSet(), new BasicStroke(3.0f), color2);
        linePlot.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.addDataSetGraphic(linePlot, PLOT_LAYER);
        this.getXAxis().setMajorTickLabelsVisible(false);
        this.getVerticalTicks().setMajorTickLabelsVisible(false);
        this.getVerticalTicks().setMinorTickLabelsVisible(false);
        this.getYAxis().setMajorTickLabelsVisible(false);
        this.getHorizontalTicks().setMajorTickLabelsVisible(false);
        this.getHorizontalTicks().setMinorTickLabelsVisible(false);
        ScatterPlot scatterPlot = new ScatterPlot(this.getComponent(), this, this.getDotDataSet(), color, 5);
        this.addDataSetGraphic(scatterPlot, PLOT_LAYER + 1.0);
        photoelectricModel.addChangeListener(new PhotoelectricModel.ChangeListenerAdapter(){

            public void currentChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsIntensityGraph.this.addDataPoint(CurrentVsIntensityGraph.this.getBeamInstensity(photoelectricModel), photoelectricModel.getCurrent());
            }

            public void voltageChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsIntensityGraph.this.clearLinePlot();
                CurrentVsIntensityGraph.this.addDataPoint(CurrentVsIntensityGraph.this.getBeamInstensity(photoelectricModel), photoelectricModel.getCurrent());
            }

            public void wavelengthChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsIntensityGraph.this.clearLinePlot();
                CurrentVsIntensityGraph.this.addDataPoint(CurrentVsIntensityGraph.this.getBeamInstensity(photoelectricModel), photoelectricModel.getCurrent());
            }

            public void targetMaterialChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsIntensityGraph.this.clearLinePlot();
            }

            public void beamIntensityChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsIntensityGraph.this.addDataPoint(CurrentVsIntensityGraph.this.getBeamInstensity(photoelectricModel), photoelectricModel.getCurrent());
            }
        });
    }

    private double getBeamInstensity(PhotoelectricModel photoelectricModel) {
        return PhotoelectricModelUtil.photonRateToIntensity(photoelectricModel.getBeam().getPhotonsPerSecond(), photoelectricModel.getBeam().getWavelength());
    }

    private void addDataPoint(double d, double d2) {
        this.setDotDataPoint(d, d2);
        this.getLineDataSet().addPoint(d, d2);
    }
}

