/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.lasers.controller.module.BaseLaserModule;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.view.WaveGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Random;

public class NonLasingWaveGraphic
extends WaveGraphic {
    private AffineTransform rtx;
    private Point2D.Double p1 = new Point2D.Double();
    private Point2D.Double p2 = new Point2D.Double();
    private Random random;
    private LaserModel model;
    private BaseLaserModule module;

    public NonLasingWaveGraphic(Component component, Point2D point2D, double d, double d2, double d3, double d4, Color color, BaseLaserModule baseLaserModule, double d5) {
        super(component, point2D, d, d2, d3, d4, color, baseLaserModule.getLaserModel().getResonatingCavity());
        this.module = baseLaserModule;
        this.model = baseLaserModule.getLaserModel();
        this.model.addModelElement(this);
        try {
            Thread.sleep(10L);
            this.random = new Random(System.currentTimeMillis());
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.rtx = AffineTransform.getRotateInstance(d5);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        GeneralPath generalPath = this.getWavePath();
        generalPath.reset();
        double d2 = this.random.nextDouble() * Math.PI;
        Point2D point2D = this.getOrigin();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        for (int i = 0; i < this.getNumPts(); i += 3) {
            double d3 = this.getDx() * (double)i;
            double d4 = this.getAmplitude() * Math.sin(d2 + d3 / this.getLambda() * Math.PI);
            this.p1.setLocation(d3, d4);
            this.rtx.transform(this.p1, this.p2);
            if (i == 0) {
                generalPath.moveTo((float)(this.p2.x + point2D.getX()), (float)(this.p2.y + point2D.getY()));
                continue;
            }
            generalPath.lineTo((float)(this.p2.x + point2D.getX()), (float)(this.p2.y + point2D.getY()));
        }
        this.update();
    }

    public void paint(Graphics2D graphics2D) {
        super.saveGraphicsState(graphics2D);
        double d = Math.min(this.getAmplitude() / 20.0, 1.0);
        if (this.module.isMirrorsEnabled()) {
            d *= 1.0 - this.module.getRightMirror().getReflectivity();
        }
        GraphicsUtil.setAlpha(graphics2D, d);
        super.paint(graphics2D);
        super.restoreGraphicsState();
    }
}

