/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.lasers.view.AnnotatedAtomGraphic;
import edu.colorado.phet.lasers.view.LevelIconAnnotatedAtomGraphic;
import java.awt.Component;

public class LevelIcon
extends CompositePhetGraphic {
    private AnnotatedAtomGraphic atomGraphic;
    private Atom atom;

    public LevelIcon(Component component, Atom atom) {
        super(component);
        this.atom = atom;
        atom.setRadius(5.0);
        this.atomGraphic = new LevelIconAnnotatedAtomGraphic(this.getComponent(), atom);
        this.addGraphic(this.atomGraphic);
        this.update();
    }

    public void update() {
        this.atom.setRadius(5.0);
        this.atomGraphic.setRegistrationPoint((int)this.atom.getRadius() / 2, 0);
        this.atomGraphic.stateChanged(null);
    }

    public void updateEnergy(double d) {
        this.atom.getCurrState().setEnergyLevel(d);
        this.update();
    }
}

