/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.lasers.view.EnergyLevelGraphic;
import java.awt.Color;
import java.awt.Container;
import javax.swing.JSlider;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnergyLifetimeSlider
extends JSlider {
    private final AtomicState atomicState;
    private final EnergyLevelGraphic graphic;
    private final Container container;
    private final int sliderWidth;
    private boolean enableNotification = true;

    public EnergyLifetimeSlider(AtomicState atomicState, EnergyLevelGraphic energyLevelGraphic, int n, int n2, Container container) {
        this.atomicState = atomicState;
        this.graphic = energyLevelGraphic;
        this.container = container;
        this.setMinimum(n2);
        this.setMaximum(n);
        this.setMajorTickSpacing(n - n2);
        this.setPaintTicks(true);
        this.setBorder(new LineBorder(Color.BLACK, 1));
        this.putClientProperty("JComponent.sizeVariant", "small");
        this.sliderWidth = 45 + (int)(15.0 * ((double)n / 400.0));
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                EnergyLifetimeSlider.this.updateModel();
            }
        });
        atomicState.addListener(new AtomicState.Listener(){

            public void energyLevelChanged(AtomicState.Event event) {
                EnergyLifetimeSlider.this.updateBounds();
                EnergyLifetimeSlider.this.repaint();
            }

            public void meanLifetimeChanged(AtomicState.Event event) {
                EnergyLifetimeSlider.this.enableNotification = false;
                EnergyLifetimeSlider.this.setValue((int)event.getMeanLifetime());
                EnergyLifetimeSlider.this.enableNotification = true;
            }
        });
        this.setValue((int)atomicState.getMeanLifeTime());
        this.updateModel();
        this.updateBounds();
    }

    public void updateBounds() {
        this.setBounds(this.container.getWidth() - 60 - 2, (int)this.graphic.getPosition().getY(), this.sliderWidth, 25);
    }

    private void updateModel() {
        this.atomicState.setMeanLifetime(this.getValue());
    }

    protected void fireStateChanged() {
        if (this.enableNotification) {
            super.fireStateChanged();
        }
    }
}

