/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.model.mirror;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.lasers.model.mirror.Mirror;
import edu.colorado.phet.lasers.model.mirror.Partial;
import edu.colorado.phet.lasers.model.mirror.ReflectionStrategy;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;

public class PartialMirror
extends Mirror {
    private Partial partialStrategy;
    private EventChannel eventChannel = new EventChannel(Listener.class);
    private Listener listenerProxy = (Listener)this.eventChannel.getListenerProxy();

    public PartialMirror(Point2D point2D, Point2D point2D2) {
        super(point2D, point2D2);
        this.partialStrategy = new Partial(1.0);
        this.addReflectionStrategy(this.partialStrategy);
    }

    public double getReflectivity() {
        return this.partialStrategy.getReflectivity();
    }

    public void setReflectivity(double d) {
        this.partialStrategy.setReflectivity(d);
        this.listenerProxy.reflectivityChanged(new ReflectivityChangedEvent(this));
    }

    public void addReflectionStrategy(ReflectionStrategy reflectionStrategy) {
        if (reflectionStrategy instanceof Partial) {
            this.partialStrategy = (Partial)reflectionStrategy;
            for (int i = 0; i < this.reflectionStrategies.size(); ++i) {
                ReflectionStrategy reflectionStrategy2 = (ReflectionStrategy)this.reflectionStrategies.get(i);
                if (!(reflectionStrategy2 instanceof Partial)) continue;
                this.reflectionStrategies.remove(reflectionStrategy2);
                break;
            }
        }
        this.reflectionStrategies.add(reflectionStrategy);
    }

    public void addListener(Listener listener) {
        this.eventChannel.addListener(listener);
    }

    public static interface Listener
    extends EventListener {
        public void reflectivityChanged(ReflectivityChangedEvent var1);
    }

    public class ReflectivityChangedEvent
    extends EventObject {
        public ReflectivityChangedEvent(Object object) {
            super(object);
        }

        public double getReflectivity() {
            return ((PartialMirror)this.source).getReflectivity();
        }
    }
}

