/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.view;

import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetButton;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.model.Spectrometer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class SpectrometerGraphic
extends GraphicLayerSet
implements Spectrometer.ChangeListener {
    private static Color UV_COLOR = new Color(180, 180, 180);
    private int imageDisplayWidth = 410;
    private PhetImageGraphic backgroundPanel;
    private Point displayOrigin = new Point(15, 115);
    private int displayHeight = 100;
    private int displayWidth = 600;
    private int horizontalDisplayMargin = 80;
    private ArrayList photonMarkers = new ArrayList();
    private double minWavelength = 300.0;
    private double maxWavelength = 800.0;
    private boolean start = true;
    protected PhetButton startStopBtn;
    boolean startStopEnabled;

    public SpectrometerGraphic(Component component, Spectrometer spectrometer) {
        super(component);
        spectrometer.addChangeListener(this);
        BufferedImage bufferedImage = DischargeLampsResources.getImage("spectrometer-panel.png");
        double d = (double)this.displayWidth / (double)this.imageDisplayWidth;
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d, 1.0), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
        bufferedImage = affineTransformOp.filter(bufferedImage, null);
        this.backgroundPanel = new PhetImageGraphic(component, bufferedImage);
        this.backgroundPanel.setIgnoreMouse(true);
        this.addGraphic(this.backgroundPanel);
        this.addButtons(component, spectrometer);
        this.addUvIRIndicators();
        this.addScale();
        this.addTitle();
        this.setCursorHand();
        this.addTranslationListener(new DefaultTranslator(this));
        if (spectrometer.isRunning()) {
            this.started(null);
        } else {
            this.stopped(null);
        }
    }

    private void addScale() {
        DecimalFormat decimalFormat = new DecimalFormat("000");
        Line2D.Double double_ = new Line2D.Double(0.0, 0.0, 0.0, 2.0);
        Line2D.Double double_2 = new Line2D.Double(0.0, 0.0, 0.0, 5.0);
        double d = 10.0;
        double d2 = 100.0;
        for (double d3 = this.minWavelength; d3 <= this.maxWavelength; d3 += d) {
            Object object;
            double d4 = (double)this.xLocForWavelength(d3) + this.displayOrigin.getX() + PhotonMarker.indicatorWidth / 2.0;
            Line2D.Double double_3 = double_;
            if ((int)d3 % (int)d2 == 0) {
                object = decimalFormat.format(d3);
                PhetTextGraphic phetTextGraphic = new PhetTextGraphic(this.getComponent(), DischargeLampsConfig.DEFAULT_CONTROL_FONT, (String)object, Color.white, (int)(d4 - 10.0), (int)(this.displayOrigin.getY() + 15.0));
                this.addGraphic(phetTextGraphic);
                phetTextGraphic.setIgnoreMouse(true);
                double_3 = double_2;
            }
            object = new PhetShapeGraphic(this.getComponent(), double_3, Color.white, new BasicStroke(1.0f), Color.white);
            ((PhetGraphic)object).setLocation((int)d4, (int)(this.displayOrigin.getY() + 4.0));
            ((PhetGraphic)object).setIgnoreMouse(true);
            this.addGraphic((PhetGraphic)object);
        }
    }

    private void addTitle() {
        String string = DischargeLampsResources.getString("spectrometer.axis.label");
        double d = this.xLocForWavelength((this.minWavelength + this.maxWavelength) / 2.0) - 50;
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(this.getComponent(), DischargeLampsConfig.DEFAULT_CONTROL_FONT, string, Color.white, (int)d, (int)(this.displayOrigin.getY() + 30.0));
        phetTextGraphic.setIgnoreMouse(true);
        this.addGraphic(phetTextGraphic);
    }

    private void addUvIRIndicators() {
        double d = (double)this.xLocForWavelength(this.minWavelength) + this.displayOrigin.getX() + PhotonMarker.indicatorWidth;
        Line2D.Double double_ = new Line2D.Double(d, this.displayOrigin.getY(), d, this.displayOrigin.getY() - (double)this.displayHeight);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getComponent(), double_, UV_COLOR, new BasicStroke(1.0f), UV_COLOR);
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(this.getComponent(), DischargeLampsConfig.DEFAULT_CONTROL_FONT, "<- " + DischargeLampsResources.getString("spectrometer.far.uv"), Color.white, (int)(d - 80.0), (int)(this.displayOrigin.getY() + 15.0));
        phetTextGraphic.setIgnoreMouse(true);
        this.addGraphic(phetTextGraphic);
        double d2 = (double)this.xLocForWavelength(this.maxWavelength) + this.displayOrigin.getX();
        Line2D.Double double_2 = new Line2D.Double(d2, this.displayOrigin.getY(), d2, this.displayOrigin.getY() - (double)this.displayHeight);
        PhetShapeGraphic phetShapeGraphic2 = new PhetShapeGraphic(this.getComponent(), double_2, UV_COLOR, new BasicStroke(1.0f), UV_COLOR);
        PhetTextGraphic phetTextGraphic2 = new PhetTextGraphic(this.getComponent(), DischargeLampsConfig.DEFAULT_CONTROL_FONT, DischargeLampsResources.getString("spectrometer.far.ir") + " ->", Color.white, (int)(d2 + 30.0), (int)(this.displayOrigin.getY() + 15.0));
        phetTextGraphic2.setIgnoreMouse(true);
        this.addGraphic(phetTextGraphic2);
    }

    private void addButtons(Component component, final Spectrometer spectrometer) {
        this.startStopBtn = new PhetButton(component, DischargeLampsResources.getString("spectrometer.start") + " ");
        this.startStopBtn.setFont(DischargeLampsConfig.DEFAULT_CONTROL_FONT);
        this.startStopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SpectrometerGraphic.this.start) {
                    spectrometer.start();
                } else {
                    spectrometer.stop();
                }
            }
        });
        this.addGraphic(this.startStopBtn);
        int n = 40;
        this.startStopBtn.setLocation(n, this.backgroundPanel.getSize().height);
        this.startStopBtn.setRegistrationPoint(0, this.startStopBtn.getHeight());
        PhetButton phetButton = new PhetButton(component, DischargeLampsResources.getString("spectrometer.reset"));
        phetButton.setFont(DischargeLampsConfig.DEFAULT_CONTROL_FONT);
        phetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                spectrometer.reset();
                SpectrometerGraphic.this.startStopEnabled = true;
            }
        });
        this.addGraphic(phetButton);
        phetButton.setLocation(n + this.startStopBtn.getWidth() + 10, this.backgroundPanel.getSize().height);
        phetButton.setRegistrationPoint(0, phetButton.getHeight());
    }

    private int xLocForWavelength(double d) {
        double d2 = d;
        d = Math.max(Math.min(d, this.maxWavelength), this.minWavelength);
        int n = (int)((d - this.minWavelength) / (this.maxWavelength - this.minWavelength) * (double)(this.displayWidth - this.horizontalDisplayMargin * 2) + (double)this.horizontalDisplayMargin);
        if (d2 < this.minWavelength) {
            n = (int)((double)n - (double)this.horizontalDisplayMargin * (this.minWavelength - d2) / this.minWavelength);
        }
        if (d2 > this.maxWavelength) {
            n = (int)((double)n + (double)this.horizontalDisplayMargin * (d2 - this.maxWavelength) / d2);
        }
        return n;
    }

    public void countChanged(Spectrometer.CountChangeEvent countChangeEvent) {
        double d = countChangeEvent.getWavelength();
        int n = this.xLocForWavelength(d);
        double d2 = 1.5;
        int n2 = (int)(-(countChangeEvent.getPhotonCount() - 1.0) * d2 * 2.0);
        if ((double)(-n2) <= (double)this.displayHeight - d2) {
            PhotonMarker photonMarker = new PhotonMarker((double)n + this.displayOrigin.getX(), (double)n2 + this.displayOrigin.getY());
            Color color = VisibleColor.wavelengthToColor(d);
            if (color.getRed() == 0 && color.getGreen() == 0 & color.getBlue() == 0) {
                color = UV_COLOR;
            }
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getComponent(), photonMarker, color);
            phetShapeGraphic.setRegistrationPoint(0, 3);
            this.photonMarkers.add(phetShapeGraphic);
            this.addGraphic(phetShapeGraphic);
            this.setBoundsDirty();
            this.repaint();
        }
    }

    public void started(Spectrometer.StateChangeEvent stateChangeEvent) {
        this.startStopBtn.setText(DischargeLampsResources.getString("spectrometer.stop") + " ");
        this.start = false;
    }

    public void stopped(Spectrometer.StateChangeEvent stateChangeEvent) {
        this.startStopBtn.setText(DischargeLampsResources.getString("spectrometer.start") + " ");
        this.start = true;
    }

    public void reset(Spectrometer.StateChangeEvent stateChangeEvent) {
        while (!this.photonMarkers.isEmpty()) {
            PhetGraphic phetGraphic = (PhetGraphic)this.photonMarkers.get(0);
            this.removeGraphic(phetGraphic);
            this.photonMarkers.remove(0);
        }
    }

    private class DefaultTranslator
    implements TranslationListener {
        private PhetGraphic graphic;

        public DefaultTranslator(PhetGraphic phetGraphic) {
            this.graphic = phetGraphic;
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            int n = translationEvent.getDx();
            int n2 = translationEvent.getDy();
            this.graphic.translate(n, n2);
        }
    }

    private static class PhotonMarker
    extends Ellipse2D.Double {
        static double indicatorWidth = 5.0;
        static double indicatorHeight = 3.0;

        public PhotonMarker(double d, double d2) {
            super(d, d2, indicatorWidth, indicatorHeight);
        }
    }
}

