/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.view;

import edu.colorado.phet.common.phetcommon.math.ModelViewTransform1D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.GroundState;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.model.ConfigurableElementProperties;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import edu.colorado.phet.dischargelamps.model.HydrogenProperties;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.dischargelamps.view.EnergySquiggle;
import edu.colorado.phet.lasers.view.EnergyLevelGraphic;
import edu.colorado.phet.lasers.view.LevelIcon;
import edu.colorado.phet.lasers.view.MonitorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DischargeLampEnergyLevelMonitorPanel
extends MonitorPanel
implements Atom.ChangeListener {
    private static BufferedImage baseSphereImg;
    private int atomDiam = 10;
    private int panelHeight = 230;
    private int minPanelWidth = 100;
    private Point2D origin;
    private int levelLineOriginX;
    private int levelLineLength;
    private Map colorToAtomImage = new HashMap();
    private EnergyLevelGraphic[] levelGraphics;
    private DischargeLampModel model;
    private ModelViewTransform1D energyYTx;
    private int headingOffsetY = 20;
    private int footerOffsetY = 20;
    private AtomicState[] atomicStates;
    private List atoms;
    private HashMap numAtomsInState = new HashMap();
    private int electronXLoc;
    private int levelLineOffsetX = 20;
    private int numAtoms;
    private double atomGraphicOverlap = 0.3;
    private int minEnergyLevelSpacing = 3;
    private double groundStateEnergy = Double.MAX_VALUE;
    private double maxEnergy = -1.7976931348623157E308;
    private EnergyLevelGraphic.ColorStrategy colorStrategy = new EnergyLevelGraphic.BlackStrategy();
    private boolean squigglesEnabled;
    private PhetGraphic groundStateTextGraphic;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public DischargeLampEnergyLevelMonitorPanel(DischargeLampModel dischargeLampModel, AtomicState[] atomicStateArray, int n, int n2) {
        this.model = dischargeLampModel;
        dischargeLampModel.addChangeListener(new DischargeLampModel.ChangeListenerAdapter(){

            public void energyLevelsChanged(DischargeLampModel.ChangeEvent changeEvent) {
                DischargeLampEnergyLevelMonitorPanel.this.setEnergyLevels(changeEvent.getDischargeLampModel().getAtomicStates());
                DischargeLampEnergyLevelMonitorPanel.this.setEnergyLevelsMovable(changeEvent.getDischargeLampModel().getElementProperties().isLevelsMovable());
            }
        });
        this.origin = new Point(25, n2 - 30);
        this.levelLineOriginX = (int)this.origin.getX() + this.levelLineOffsetX;
        this.levelLineLength = n - this.levelLineOriginX - 20;
        this.electronXLoc = (int)this.origin.getX();
        this.setPanelSize(n, n2, atomicStateArray);
        this.setBackground(Color.white);
        this.setEnergyLevels(atomicStateArray);
        this.setEnergyLevelsMovable(dischargeLampModel.getElementProperties().isLevelsMovable());
        this.addAtomListeners();
        this.addComponentListener(new PanelResizer());
        this.relayout();
    }

    private void setPanelSize(int n, int n2, AtomicState[] atomicStateArray) {
        this.panelHeight = n2;
        this.minPanelWidth = n;
        HydrogenProperties hydrogenProperties = new HydrogenProperties();
        double d = hydrogenProperties.getEnergyLevels()[hydrogenProperties.getEnergyLevels().length - 1] - hydrogenProperties.getEnergyLevels()[0];
        double d2 = atomicStateArray[atomicStateArray.length - 1].getEnergyLevel() - atomicStateArray[0].getEnergyLevel();
        double d3 = 0.0;
        d3 = this.model.getElementProperties() instanceof ConfigurableElementProperties ? 1.0 : d2 / d;
        this.setPreferredSize(new Dimension(n, (int)((double)n2 * d3)));
    }

    private void initializeStateCounters() {
        int n;
        this.atoms = this.model.getAtoms();
        this.numAtomsInState.clear();
        for (n = 0; n < this.atomicStates.length; ++n) {
            this.numAtomsInState.put(this.atomicStates[n], new Integer(0));
        }
        for (n = 0; n < this.atoms.size(); ++n) {
            Atom atom = (Atom)this.atoms.get(n);
            Integer n2 = (Integer)this.numAtomsInState.get(atom.getCurrState());
            if (n2 == null) continue;
            this.numAtomsInState.put(atom.getCurrState(), new Integer(n2 + 1));
        }
        this.invalidate();
        this.repaint();
    }

    public void addAtom(Atom atom) {
        atom.addChangeListener(this);
        ++this.numAtoms;
        int n = (Integer)this.numAtomsInState.get(atom.getCurrState());
        this.numAtomsInState.put(atom.getCurrState(), new Integer(n + 1));
    }

    public void setSquigglesEnabled(boolean bl) {
        this.squigglesEnabled = bl;
    }

    public void setEnergyLevelsMovable(boolean bl) {
        for (int i = 0; i < this.levelGraphics.length; ++i) {
            EnergyLevelGraphic energyLevelGraphic = this.levelGraphics[i];
            energyLevelGraphic.setIgnoreMouse(!bl);
        }
    }

    public void setEnergyLevels(AtomicState[] atomicStateArray) {
        int n;
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (n = 0; n < atomicStateArray.length; ++n) {
            double d3 = atomicStateArray[n].getEnergyLevel();
            d = Math.min(d, d3);
            d2 = Math.max(d, d3);
        }
        this.groundStateEnergy = d;
        this.maxEnergy = d2;
        for (n = 0; this.levelGraphics != null && n < this.levelGraphics.length; ++n) {
            this.removeGraphic(this.levelGraphics[n]);
        }
        this.atomicStates = atomicStateArray;
        this.levelGraphics = new EnergyLevelGraphic[atomicStateArray.length];
        this.levelLineLength = (int)((double)(this.numAtoms - 1) * ((double)this.atomDiam * (1.0 - this.atomGraphicOverlap)) + (double)this.atomDiam * 1.5);
        for (n = 0; n < this.levelGraphics.length; ++n) {
            this.levelGraphics[n] = new EnergyLevelGraphic(this, atomicStateArray[n], atomicStateArray[0].getEnergyLevel(), this.levelLineOriginX, this.levelLineLength, !(atomicStateArray[n] instanceof GroundState), this.levelLineOriginX + this.levelLineLength + 20, false);
            this.levelGraphics[n].setArrowsEnabled(false);
            this.levelGraphics[n].setColorStrategy(this.colorStrategy);
            Atom atom = new Atom(this.model, this.levelGraphics.length, true);
            AtomicState[] atomicStateArray2 = new AtomicState[atomicStateArray.length];
            for (int i = 0; i < atomicStateArray.length; ++i) {
                atomicStateArray2[i] = new AtomicState(atomicStateArray[i]);
                atomicStateArray2[i].setMeanLifetime(Double.MAX_VALUE);
            }
            atom.setStates(atomicStateArray2);
            atom.setCurrState(atomicStateArray2[n]);
            this.levelGraphics[n].setLevelIcon(new LevelIcon(this, atom));
            this.levelGraphics[n].setMinPixelsBetweenLevels(this.minEnergyLevelSpacing);
            this.addGraphic(this.levelGraphics[n]);
            this.levelGraphics[n].addTranslationListener(new TranslationListener(){

                public void translationOccurred(TranslationEvent translationEvent) {
                    DischargeLampEnergyLevelMonitorPanel.this.initializeStateCounters();
                }
            });
        }
        n = Math.max(this.minPanelWidth, this.levelLineLength + this.levelLineOriginX + 35);
        this.setPanelSize(n, this.panelHeight, atomicStateArray);
        this.relayout();
        this.initializeStateCounters();
        this.revalidate();
        this.repaint();
    }

    private void addAtomListeners() {
        this.atoms = this.model.getAtoms();
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            atom.addChangeListener(this);
        }
    }

    private void relayout() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getPreferredSize().getWidth(), this.getPreferredSize().getHeight());
        this.energyYTx = new ModelViewTransform1D(this.maxEnergy, this.groundStateEnergy, (int)double_.getBounds().getMinY() + this.headingOffsetY, (int)double_.getBounds().getMaxY() - this.footerOffsetY);
        for (int i = 0; this.levelGraphics != null && i < this.levelGraphics.length; ++i) {
            this.levelGraphics[i].setTransform(this.energyYTx);
            if (i != 0 || this.groundStateTextGraphic == null) continue;
            int n = this.energyYTx.modelToView(this.atomicStates[0].getEnergyLevel());
            this.groundStateTextGraphic.setLocation((int)this.groundStateTextGraphic.getLocation().getX(), n - this.groundStateTextGraphic.getHeight() / 2);
        }
        this.changeListenerProxy.energyTxChanged(this.energyYTx);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        for (int i = 0; i < this.atomicStates.length; ++i) {
            Color color = this.colorStrategy.getColor(this.atomicStates[i], this.atomicStates[0].getEnergyLevel());
            Integer n = (Integer)this.numAtomsInState.get(this.atomicStates[i]);
            if (n == null) continue;
            int n2 = n;
            this.drawAtomsInLevel(graphics2D, color, this.levelGraphics[i], n2);
        }
        graphicsState.restoreGraphics();
    }

    private void drawAtomsInLevel(Graphics2D graphics2D, Color color, EnergyLevelGraphic energyLevelGraphic, int n) {
        BufferedImage bufferedImage = this.getAtomImage(color);
        double d = (double)this.atomDiam / (double)bufferedImage.getWidth();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(energyLevelGraphic.getLinePosition().getX() - (double)(this.atomDiam / 2), energyLevelGraphic.getLinePosition().getY() - (double)this.atomDiam);
        affineTransform.scale(d, d);
        for (int i = 0; i < n; ++i) {
            affineTransform.translate((double)this.atomDiam * (1.0 - this.atomGraphicOverlap) / d, 0.0);
            graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        }
    }

    private BufferedImage getAtomImage(Color color) {
        BufferedImage bufferedImage = (BufferedImage)this.colorToAtomImage.get(color);
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(baseSphereImg.getWidth(), baseSphereImg.getHeight(), 3);
            MakeDuotoneImageOp makeDuotoneImageOp = new MakeDuotoneImageOp(color);
            makeDuotoneImageOp.filter(baseSphereImg, bufferedImage);
            this.colorToAtomImage.put(color, bufferedImage);
        }
        return bufferedImage;
    }

    public ModelViewTransform1D getEnergyYTx() {
        return this.energyYTx;
    }

    public void stateChanged(Atom.ChangeEvent changeEvent) {
        Integer n;
        AtomicState atomicState = changeEvent.getPrevState();
        AtomicState atomicState2 = changeEvent.getCurrState();
        Integer n2 = (Integer)this.numAtomsInState.get(atomicState);
        if (n2 != null) {
            this.numAtomsInState.put(atomicState, new Integer(n2 - 1));
        }
        if ((n = (Integer)this.numAtomsInState.get(atomicState2)) != null) {
            this.numAtomsInState.put(atomicState2, new Integer(n + 1));
        }
        if (this.squigglesEnabled) {
            this.displaySquiggle(atomicState, atomicState2);
        }
        this.invalidate();
        this.repaint();
    }

    private void displaySquiggle(AtomicState atomicState, AtomicState atomicState2) {
        double d = atomicState.getEnergyLevel() - atomicState2.getEnergyLevel();
        if (d > 0.0) {
            double d2 = PhysicsUtil.energyToWavelength(d);
            int n = Math.abs(this.energyYTx.modelToView(atomicState.getEnergyLevel()) - this.energyYTx.modelToView(atomicState2.getEnergyLevel()));
            final EnergySquiggle energySquiggle = new EnergySquiggle(this, d2, 0.0, n, 10, 1);
            energySquiggle.setLocation(50, this.energyYTx.modelToView(atomicState.getEnergyLevel()));
            this.addGraphic(energySquiggle);
            energySquiggle.setBoundsDirty();
            energySquiggle.repaint();
            final IClock iClock = PhetUtilities.getActiveClock();
            iClock.addClockListener(new ClockAdapter(){
                double t0;
                double timeout;
                {
                    this.t0 = iClock.getSimulationTime();
                    this.timeout = 50.0;
                }

                public void clockTicked(ClockEvent clockEvent) {
                    double d = iClock.getSimulationTime();
                    if (d - this.t0 > this.timeout) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DischargeLampEnergyLevelMonitorPanel.this.removeGraphic(energySquiggle);
                            }
                        });
                        iClock.removeClockListener(this);
                    }
                }
            });
        }
    }

    public void positionChanged(Atom.ChangeEvent changeEvent) {
    }

    public void addElectron(Electron electron) {
        new ElectronGraphicManager(electron);
    }

    public void addGroundStateLabel(PhetGraphic phetGraphic, int n) {
        this.groundStateTextGraphic = phetGraphic;
        this.addGraphic(phetGraphic, n);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    static {
        try {
            baseSphereImg = ImageLoader.loadBufferedImage("lasers/images/particle-red-lrg.gif");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void energyTxChanged(ModelViewTransform1D var1);
    }

    private class ElectronGraphicManager
    implements Electron.ChangeListener {
        PhetGraphic electronGraphic;

        public ElectronGraphicManager(Electron electron) {
            this.electronGraphic = new PhetImageGraphic((Component)DischargeLampEnergyLevelMonitorPanel.this, DischargeLampsResources.getImage("electron.gif"));
            int n = DischargeLampEnergyLevelMonitorPanel.this.energyYTx.modelToView(electron.getEnergy() + DischargeLampEnergyLevelMonitorPanel.this.groundStateEnergy);
            this.electronGraphic.setLocation(DischargeLampEnergyLevelMonitorPanel.this.electronXLoc, n);
            DischargeLampEnergyLevelMonitorPanel.this.addGraphic(this.electronGraphic);
            electron.addChangeListener(this);
        }

        public void leftSystem(Electron.ChangeEvent changeEvent) {
            DischargeLampEnergyLevelMonitorPanel.this.removeGraphic(this.electronGraphic);
        }

        public void energyChanged(Electron.ChangeEvent changeEvent) {
            int n = DischargeLampEnergyLevelMonitorPanel.this.energyYTx.modelToView(changeEvent.getElectron().getEnergy() + DischargeLampEnergyLevelMonitorPanel.this.groundStateEnergy) - 10;
            this.electronGraphic.setLocation(DischargeLampEnergyLevelMonitorPanel.this.electronXLoc, n);
            this.electronGraphic.setBoundsDirty();
            this.electronGraphic.repaint();
        }
    }

    private class PanelResizer
    extends ComponentAdapter {
        private PanelResizer() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            DischargeLampEnergyLevelMonitorPanel.this.relayout();
        }
    }
}

