/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.quantum;

import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.GroundState;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;

public class AtomicStateFactory {
    public AtomicState[] createAtomicStates(int n) {
        AtomicState[] atomicStateArray = new AtomicState[n];
        double d = -13.6;
        double d2 = -0.3;
        double d3 = (d2 - d) / (double)(atomicStateArray.length - 1);
        atomicStateArray[0] = new GroundState();
        atomicStateArray[0].setEnergyLevel(d);
        atomicStateArray[1] = new AtomicState();
        atomicStateArray[1].setEnergyLevel(d + 4.0);
        atomicStateArray[0].setNextHigherEnergyState(atomicStateArray[1]);
        atomicStateArray[1].setNextLowerEnergyState(atomicStateArray[0]);
        atomicStateArray[1].setMeanLifetime(DischargeLampAtom.DEFAULT_STATE_LIFETIME);
        d3 = d2 - atomicStateArray[1].getEnergyLevel() / 4.0;
        for (int i = 2; i < atomicStateArray.length && i < 6; ++i) {
            atomicStateArray[i] = new AtomicState();
            atomicStateArray[i].setMeanLifetime(DischargeLampAtom.DEFAULT_STATE_LIFETIME);
            atomicStateArray[i].setEnergyLevel(atomicStateArray[i - 1].getEnergyLevel() + d3);
            atomicStateArray[i].setNextLowerEnergyState(atomicStateArray[i - 1]);
            atomicStateArray[i - 1].setNextHigherEnergyState(atomicStateArray[i]);
        }
        atomicStateArray[atomicStateArray.length - 1].setNextHigherEnergyState(AtomicState.MaxEnergyState.instance());
        return atomicStateArray;
    }

    public AtomicState[] createAtomicStates(int n, AtomicState[] atomicStateArray) {
        double d = -0.3;
        if (atomicStateArray.length < 2) {
            return this.createAtomicStates(n);
        }
        AtomicState[] atomicStateArray2 = new AtomicState[n];
        double d2 = (d - atomicStateArray[atomicStateArray.length - 1].getEnergyLevel()) / (double)(6 - atomicStateArray.length);
        for (int i = 0; i < atomicStateArray2.length; ++i) {
            if (i < atomicStateArray.length) {
                atomicStateArray2[i] = atomicStateArray[i];
                continue;
            }
            atomicStateArray2[i] = new AtomicState();
            atomicStateArray2[i].setMeanLifetime(DischargeLampAtom.DEFAULT_STATE_LIFETIME);
            atomicStateArray2[i].setEnergyLevel(atomicStateArray2[i - 1].getEnergyLevel() + d2);
            atomicStateArray2[i].setNextLowerEnergyState(atomicStateArray2[i - 1]);
            atomicStateArray2[i - 1].setNextHigherEnergyState(atomicStateArray2[i]);
        }
        atomicStateArray2[atomicStateArray2.length - 1].setNextHigherEnergyState(AtomicState.MaxEnergyState.instance());
        return atomicStateArray2;
    }
}

