/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.ElectromotiveForce;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.model.Battery;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.model.DischargeLampElementProperties;
import edu.colorado.phet.dischargelamps.model.HeatingElement;
import edu.colorado.phet.dischargelamps.model.Spectrometer;
import edu.colorado.phet.dischargelamps.quantum.model.Electrode;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronAtomCollisionExpert;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSink;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSource;
import edu.colorado.phet.dischargelamps.quantum.model.Plate;
import edu.colorado.phet.lasers.model.LaserModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class DischargeLampModel
extends LaserModel
implements ElectromotiveForce {
    private List atoms = new ArrayList();
    private ArrayList electrons = new ArrayList();
    private ArrayList electronSources = new ArrayList();
    private ArrayList electronSinks = new ArrayList();
    private ElectronAtomCollisionExpert electronAtomCollisionExpert = new ElectronAtomCollisionExpert();
    private Spectrometer spectrometer;
    private MutableVector2D electronAcceleration = new MutableVector2D();
    private Tube tube;
    private Plate leftHandPlate;
    private Plate rightHandPlate;
    private HeatingElement leftHandHeatingElement;
    private HeatingElement rightHandHeatingElement;
    private Battery battery;
    private double current;
    private double maxCurrent;
    private DischargeLampElementProperties elementProperties;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public DischargeLampModel() {
        super(1.0);
        this.battery = new Battery(-30.0, 30.0);
        this.battery.addChangeListener(new Battery.ChangeListener(){

            public void voltageChanged(Battery.ChangeEvent changeEvent) {
                DischargeLampModel.this.setVoltage(changeEvent.getVoltageSource().getVoltage());
            }
        });
        this.leftHandPlate = new Plate(this, this, DischargeLampsConfig.CATHODE_LINE.getP1(), DischargeLampsConfig.CATHODE_LINE.getP2());
        this.leftHandPlate.addStateChangeListener(new ElectrodeStateChangeListener());
        this.leftHandPlate.addElectronProductionListener(new ElectronSource.ElectronProductionListener(){

            public void electronProduced(ElectronSource.ElectronProductionEvent electronProductionEvent) {
                DischargeLampModel.this.addModelElement(electronProductionEvent.getElectron());
            }
        });
        this.rightHandPlate = new Plate(this, this, DischargeLampsConfig.ANODE_LINE.getP1(), DischargeLampsConfig.ANODE_LINE.getP2());
        this.rightHandPlate.addStateChangeListener(new ElectrodeStateChangeListener());
        this.rightHandPlate.addElectronProductionListener(new ElectronSource.ElectronProductionListener(){

            public void electronProduced(ElectronSource.ElectronProductionEvent electronProductionEvent) {
                DischargeLampModel.this.addModelElement(electronProductionEvent.getElectron());
            }
        });
        this.leftHandHeatingElement = new HeatingElement();
        this.leftHandHeatingElement.setPosition(DischargeLampsConfig.CATHODE_LOCATION.getX(), DischargeLampsConfig.CATHODE_LOCATION.getY());
        this.rightHandHeatingElement = new HeatingElement();
        this.rightHandHeatingElement.setPosition(DischargeLampsConfig.ANODE_LOCATION.getX(), DischargeLampsConfig.ANODE_LOCATION.getY());
        double d = DischargeLampsConfig.CATHODE_LOCATION.getX() - (double)DischargeLampsConfig.ELECTRODE_INSETS.left;
        double d2 = DischargeLampsConfig.CATHODE_LOCATION.getY() - 100.0 - (double)DischargeLampsConfig.ELECTRODE_INSETS.top;
        double d3 = DischargeLampsConfig.ANODE_LOCATION.getX() - DischargeLampsConfig.CATHODE_LOCATION.getX() + (double)DischargeLampsConfig.ELECTRODE_INSETS.left + (double)DischargeLampsConfig.ELECTRODE_INSETS.right;
        double d4 = 200.0 + (double)DischargeLampsConfig.ELECTRODE_INSETS.top + (double)DischargeLampsConfig.ELECTRODE_INSETS.bottom;
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.tube = new Tube((Point2D)double_, d3, d4);
        this.addModelElement(this.tube);
        this.spectrometer = new Spectrometer();
    }

    public void update(ClockEvent clockEvent) {
        super.update(clockEvent);
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            for (int j = 0; j < this.electrons.size(); ++j) {
                Electron electron = (Electron)this.electrons.get(j);
                this.electronAtomCollisionExpert.detectAndDoCollision(atom, electron);
            }
        }
    }

    public void addModelElement(ModelElement modelElement) {
        ModelElement modelElement2;
        int n;
        ModelElement modelElement3;
        super.addModelElement(modelElement);
        if (modelElement instanceof Atom) {
            modelElement3 = (Atom)modelElement;
            this.atoms.add(modelElement3);
            ((Atom)modelElement3).addPhotonEmittedListener(this.getSpectrometer());
        }
        if (modelElement instanceof Electron) {
            modelElement3 = (Electron)modelElement;
            ((Particle)modelElement3).setAcceleration(this.getElectronAcceleration());
            this.electrons.add(modelElement3);
        }
        if (modelElement instanceof ElectronSink) {
            modelElement3 = (ElectronSink)modelElement;
            this.electronSinks.add(modelElement3);
            for (n = 0; n < this.electronSources.size(); ++n) {
                modelElement2 = (ElectronSource)this.electronSources.get(n);
                modelElement2.addListener((ElectronSource.ElectronProductionListener)((Object)modelElement3));
            }
        }
        if (modelElement instanceof ElectronSource) {
            modelElement3 = (ElectronSource)modelElement;
            this.electronSources.add(modelElement3);
            for (n = 0; n < this.electronSinks.size(); ++n) {
                modelElement2 = (ElectronSink)this.electronSinks.get(n);
                ((ElectronSource)modelElement3).addListener((ElectronSource.ElectronProductionListener)((Object)modelElement2));
            }
        }
    }

    public void removeModelElement(ModelElement modelElement) {
        super.removeModelElement(modelElement);
        if (modelElement instanceof Atom) {
            this.atoms.remove(modelElement);
        }
        if (modelElement instanceof Electron) {
            this.electrons.remove(modelElement);
        }
    }

    public void setElementProperties(DischargeLampElementProperties dischargeLampElementProperties) {
        this.elementProperties = dischargeLampElementProperties;
        for (int i = 0; i < this.atoms.size(); ++i) {
            DischargeLampAtom dischargeLampAtom = (DischargeLampAtom)this.atoms.get(i);
            dischargeLampAtom.setElementProperties(dischargeLampElementProperties);
        }
        this.changeListenerProxy.energyLevelsChanged(new ChangeEvent(this));
    }

    public DischargeLampElementProperties getElementProperties() {
        return this.elementProperties;
    }

    public AtomicState[] getAtomicStates() {
        return this.getElementProperties().getStates();
    }

    public Tube getTube() {
        return this.tube;
    }

    public Spectrometer getSpectrometer() {
        return this.spectrometer;
    }

    protected void setElectronAcceleration(double d, double d2) {
        this.electronAcceleration.setComponents(d / d2, 0.0);
    }

    public MutableVector2D getElectronAcceleration() {
        return this.electronAcceleration;
    }

    public List getAtoms() {
        return this.atoms;
    }

    public void setMaxCurrent(double d) {
        this.maxCurrent = d;
    }

    public void setCurrent(double d, double d2) {
        this.setCurrent(d * d2);
    }

    public void setCurrent(double d) {
        this.current = d;
        this.leftHandHeatingElement.setTemperature(0.0);
        this.rightHandHeatingElement.setTemperature(0.0);
        double d2 = 255.0 * d * 1000.0 / this.maxCurrent;
        if (this.leftHandPlate.getPotential() > this.rightHandPlate.getPotential()) {
            this.leftHandPlate.setCurrent(d);
            this.rightHandPlate.setCurrent(0.0);
            this.leftHandHeatingElement.setTemperature(d2);
        } else {
            this.rightHandPlate.setCurrent(d);
            this.leftHandPlate.setCurrent(0.0);
            this.rightHandHeatingElement.setTemperature(d2);
        }
        this.changeListenerProxy.currentChanged(new ChangeEvent(this));
    }

    public double getCurrent() {
        return this.current;
    }

    public Battery getBattery() {
        return this.battery;
    }

    protected void setLeftHandPlate(Plate plate) {
        this.leftHandPlate = plate;
    }

    public Plate getLeftHandPlate() {
        return this.leftHandPlate;
    }

    protected void setRightHandPlate(Plate plate) {
        this.rightHandPlate = plate;
    }

    public Plate getRightHandPlate() {
        return this.rightHandPlate;
    }

    public HeatingElement getLeftHandHeatingElement() {
        return this.leftHandHeatingElement;
    }

    public HeatingElement getRightHandHeatingElement() {
        return this.rightHandHeatingElement;
    }

    private void setHeatingElementsEnabled(boolean bl) {
        this.leftHandHeatingElement.setIsEnabled(bl);
        this.rightHandHeatingElement.setIsEnabled(bl);
    }

    public void setElectronProductionMode(Object object) {
        for (int i = 0; i < this.electronSources.size(); ++i) {
            ElectronSource electronSource = (ElectronSource)this.electronSources.get(i);
            electronSource.setElectronProductionMode(object);
        }
        this.setHeatingElementsEnabled(object == ElectronSource.CONTINUOUS_MODE);
    }

    public void setVoltage(double d) {
        if (d > 0.0) {
            this.leftHandPlate.setPotential(d);
            this.rightHandPlate.setPotential(0.0);
        } else {
            this.leftHandPlate.setPotential(0.0);
            this.rightHandPlate.setPotential(-d);
        }
        this.changeListenerProxy.voltageChanged(new ChangeEvent(this));
    }

    public double getVoltage() {
        return this.leftHandPlate.getPotential() - this.rightHandPlate.getPotential();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public DischargeLampModel getDischargeLampModel() {
            return (DischargeLampModel)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void energyLevelsChanged(ChangeEvent var1);

        public void voltageChanged(ChangeEvent var1);

        public void currentChanged(ChangeEvent var1);
    }

    public static class ChangeListenerAdapter
    implements ChangeListener {
        public void energyLevelsChanged(ChangeEvent changeEvent) {
        }

        public void voltageChanged(ChangeEvent changeEvent) {
        }

        public void currentChanged(ChangeEvent changeEvent) {
        }
    }

    private class ElectrodeStateChangeListener
    implements Electrode.StateChangeListener {
        private ElectrodeStateChangeListener() {
        }

        public void potentialChanged(Electrode.StateChangeEvent stateChangeEvent) {
            double d = DischargeLampModel.this.leftHandPlate.getPotential() - DischargeLampModel.this.rightHandPlate.getPotential();
            DischargeLampModel.this.setElectronAcceleration(d * 0.1801801801801802, DischargeLampModel.this.leftHandPlate.getPosition().distance(DischargeLampModel.this.rightHandPlate.getPosition()));
            for (int i = 0; i < DischargeLampModel.this.electrons.size(); ++i) {
                Electron electron = (Electron)DischargeLampModel.this.electrons.get(i);
                electron.setAcceleration(DischargeLampModel.this.getElectronAcceleration());
            }
            DischargeLampModel.this.setCurrent(DischargeLampModel.this.current);
        }
    }
}

