/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps;

import edu.colorado.phet.common.phetcommon.model.clock.Clock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.common.quantum.model.Atom;
import edu.colorado.phet.common.quantum.model.AtomicState;
import edu.colorado.phet.common.quantum.model.ElementProperties;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PhotonEmissionListener;
import edu.colorado.phet.common.quantum.model.PhotonEmittedEvent;
import edu.colorado.phet.common.quantum.model.StimulatedPhoton;
import edu.colorado.phet.common.quantum.model.Tube;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.DischargeLampsResources;
import edu.colorado.phet.dischargelamps.ShowActualButton;
import edu.colorado.phet.dischargelamps.control.AtomTypeChooser;
import edu.colorado.phet.dischargelamps.control.BatterySlider;
import edu.colorado.phet.dischargelamps.control.ElectronProductionControl;
import edu.colorado.phet.dischargelamps.control.SlowMotionCheckBox;
import edu.colorado.phet.dischargelamps.model.Battery;
import edu.colorado.phet.dischargelamps.model.ConfigurableElementProperties;
import edu.colorado.phet.dischargelamps.model.DischargeLampAtom;
import edu.colorado.phet.dischargelamps.model.DischargeLampModel;
import edu.colorado.phet.dischargelamps.model.HydrogenProperties;
import edu.colorado.phet.dischargelamps.model.MercuryProperties;
import edu.colorado.phet.dischargelamps.model.NeonProperties;
import edu.colorado.phet.dischargelamps.model.SodiumProperties;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSource;
import edu.colorado.phet.dischargelamps.quantum.model.Plate;
import edu.colorado.phet.dischargelamps.quantum.view.PlateGraphic;
import edu.colorado.phet.dischargelamps.view.BatteryReadout;
import edu.colorado.phet.dischargelamps.view.CircuitGraphic;
import edu.colorado.phet.dischargelamps.view.DischargeLampEnergyMonitorPanel2;
import edu.colorado.phet.dischargelamps.view.DischargeLampsLegend;
import edu.colorado.phet.dischargelamps.view.ElectronGraphicManager;
import edu.colorado.phet.dischargelamps.view.HeatingElementGraphic;
import edu.colorado.phet.dischargelamps.view.SpectrometerGraphic;
import edu.colorado.phet.lasers.model.LaserModel;
import edu.colorado.phet.lasers.view.AnnotatedAtomGraphic;
import edu.colorado.phet.lasers.view.AtomGraphic;
import edu.colorado.phet.lasers.view.PhotonGraphic;
import edu.colorado.phet.lasers.view.TubeGraphic;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class DischargeLampModule
extends PhetGraphicsModule {
    public static boolean DEBUG = false;
    private static double VOLTAGE_VALUE_LAYER = 121.0;
    private Tube tube;
    private Random random = new Random();
    private DischargeLampModel model;
    private Plate leftHandPlate;
    private Plate rightHandPlate;
    private ElementProperties[] elementProperties;
    private ConfigurableElementProperties configurableElement;
    private double externalGraphicsScale;
    private AffineTransformOp externalGraphicScaleOp;
    private DischargeLampEnergyMonitorPanel2 energyLevelsMonitorPanel;
    private SpectrometerGraphic spectrometerGraphic;
    private HeatingElementGraphic[] heatingElementGraphics = new HeatingElementGraphic[2];
    private JCheckBox squiggleCB;
    private JPanel optionsPanel;
    private ElectronProductionControl electronProductionControl;

    protected DischargeLampModule(String string, IClock iClock) {
        super(string, iClock);
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(iClock, 709, 607);
        apparatusPanel3.setPaintStrategy(2);
        apparatusPanel3.setBackground(Color.white);
        this.setApparatusPanel(apparatusPanel3);
        this.model = new DischargeLampModel();
        this.model.setElectronProductionMode(ElectronSource.CONTINUOUS_MODE);
        this.model.setMaxCurrent(this.getMaxCurrent());
        this.leftHandPlate = this.model.getLeftHandPlate();
        this.rightHandPlate = this.model.getRightHandPlate();
        this.model.setVoltage(23.0);
        this.setModel(this.model);
        this.setControlPanel(new ControlPanel(this));
        this.configurableElement = new ConfigurableElementProperties(2, this.model);
        this.elementProperties = new ElementProperties[]{new HydrogenProperties(), new MercuryProperties(), new SodiumProperties(), new NeonProperties(), this.configurableElement};
        this.addCircuitGraphic(apparatusPanel3);
        this.addCathodeGraphic(apparatusPanel3);
        this.addAnodeGraphic(apparatusPanel3);
        this.addSpectrometerGraphic();
        this.addHeatingElementGraphics();
        this.addTubeGraphic(apparatusPanel3);
        this.addGraphicBatteryControls();
        this.addControls();
        StimulatedPhoton.setStimulationBounds(this.model.getTube().getBounds());
    }

    public void activate() {
        super.activate();
        this.electronProductionControl.setVisible(true);
    }

    public void deactivate() {
        super.deactivate();
        this.electronProductionControl.setVisible(false);
    }

    private void addGraphicBatteryControls() {
        Battery battery = this.model.getBattery();
        BatterySlider batterySlider = new BatterySlider(this.getApparatusPanel(), 80, battery, 1.0);
        batterySlider.setMinimum((int)(-battery.getMaxVoltage()));
        batterySlider.setMaximum((int)battery.getMaxVoltage());
        batterySlider.setValue(23.0);
        batterySlider.addTick(batterySlider.getMinimum());
        batterySlider.addTick(batterySlider.getMaximum());
        batterySlider.addTick(0.0);
        batterySlider.setLocation((int)DischargeLampsConfig.CATHODE_LOCATION.getX() + 174, (int)DischargeLampsConfig.CATHODE_LOCATION.getY() - 240);
        this.getApparatusPanel().addGraphic(batterySlider, 121.0);
        BatteryReadout batteryReadout = new BatteryReadout(this.getApparatusPanel(), battery, new Point((int)DischargeLampsConfig.CATHODE_LOCATION.getX() + 194, batterySlider.getY() + 17), 35);
        this.addGraphic(batteryReadout, VOLTAGE_VALUE_LAYER);
    }

    private void addHeatingElementGraphics() {
        int n = -173;
        int n2 = 45;
        HeatingElementGraphic heatingElementGraphic = new HeatingElementGraphic((Component)this.getApparatusPanel(), true);
        this.getApparatusPanel().addGraphic(heatingElementGraphic);
        Point point = new Point((int)this.model.getLeftHandHeatingElement().getPosition().getX() - heatingElementGraphic.getImage().getWidth() + n2, (int)this.model.getLeftHandHeatingElement().getPosition().getY() + n);
        heatingElementGraphic.setLocation(point);
        HeatingElementGraphic heatingElementGraphic2 = new HeatingElementGraphic((Component)this.getApparatusPanel(), false);
        this.getApparatusPanel().addGraphic(heatingElementGraphic2);
        Point point2 = new Point((int)this.model.getRightHandHeatingElement().getPosition().getX() - n2, (int)this.model.getRightHandHeatingElement().getPosition().getY() + n);
        heatingElementGraphic2.setLocation(point2);
        this.heatingElementGraphics[0] = heatingElementGraphic;
        this.heatingElementGraphics[1] = heatingElementGraphic2;
        this.model.getLeftHandHeatingElement().addChangeListener(heatingElementGraphic);
        this.model.getRightHandHeatingElement().addChangeListener(heatingElementGraphic2);
        this.leftHandPlate.addElectronProductionListener(new ElectronGraphicManager(this.getApparatusPanel()));
        this.rightHandPlate.addElectronProductionListener(new ElectronGraphicManager(this.getApparatusPanel()));
    }

    private void addTubeGraphic(ApparatusPanel apparatusPanel) {
        Tube tube = this.model.getTube();
        TubeGraphic tubeGraphic = new TubeGraphic(this.getApparatusPanel(), tube);
        apparatusPanel.addGraphic(tubeGraphic, 110.0);
        this.tube = tube;
    }

    private void addAnodeGraphic(ApparatusPanel apparatusPanel) {
        PlateGraphic plateGraphic = new PlateGraphic(this.getApparatusPanel(), 200.0);
        this.model.getRightHandHeatingElement().addChangeListener(plateGraphic);
        plateGraphic.setRegistrationPoint((int)plateGraphic.getBounds().getWidth(), (int)plateGraphic.getBounds().getHeight() / 2);
        plateGraphic.setRegistrationPoint(0, (int)plateGraphic.getBounds().getHeight() / 2);
        plateGraphic.setLocation(DischargeLampsConfig.ANODE_LOCATION);
        apparatusPanel.addGraphic(plateGraphic, 120.0);
    }

    private void addCathodeGraphic(ApparatusPanel apparatusPanel) {
        PlateGraphic plateGraphic = new PlateGraphic(this.getApparatusPanel(), 200.0);
        this.model.getLeftHandHeatingElement().addChangeListener(plateGraphic);
        plateGraphic.setRegistrationPoint((int)plateGraphic.getBounds().getWidth(), (int)plateGraphic.getBounds().getHeight() / 2);
        plateGraphic.setLocation(DischargeLampsConfig.CATHODE_LOCATION);
        apparatusPanel.addGraphic(plateGraphic, 120.0);
    }

    private void addCircuitGraphic(ApparatusPanel apparatusPanel) {
        CircuitGraphic circuitGraphic = new CircuitGraphic((Component)apparatusPanel, this.getExternalGraphicScaleOp());
        this.model.addChangeListener(circuitGraphic);
        circuitGraphic.setRegistrationPoint((int)(124.0 * this.externalGraphicsScale), (int)(340.0 * this.externalGraphicsScale));
        circuitGraphic.setLocation(DischargeLampsConfig.CATHODE_LOCATION);
        apparatusPanel.addGraphic(circuitGraphic, 120.0);
    }

    private void addSpectrometerGraphic() {
        this.spectrometerGraphic = new SpectrometerGraphic(this.getApparatusPanel(), this.model.getSpectrometer());
        this.addGraphic(this.spectrometerGraphic, 1000.0);
        int n = (DischargeLampsConfig.ANODE_LOCATION.x + DischargeLampsConfig.CATHODE_LOCATION.x) / 2;
        int n2 = DischargeLampsConfig.CATHODE_LOCATION.y + 125;
        this.spectrometerGraphic.setLocation(n, n2);
        this.spectrometerGraphic.setRegistrationPoint(this.spectrometerGraphic.getWidth() / 2, 0);
    }

    private AffineTransformOp getExternalGraphicScaleOp() {
        if (this.externalGraphicScaleOp == null) {
            int n = 550;
            this.determineExternalGraphicScale(DischargeLampsConfig.ANODE_LOCATION, DischargeLampsConfig.CATHODE_LOCATION, n);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(this.externalGraphicsScale, this.externalGraphicsScale);
            this.externalGraphicScaleOp = new AffineTransformOp(affineTransform, 2);
        }
        return this.externalGraphicScaleOp;
    }

    private void determineExternalGraphicScale(Point point, Point point2, int n) {
        this.externalGraphicsScale = point.distance(point2) / (double)n;
    }

    private void addControls() {
        ControlPanel controlPanel = this.getControlPanel();
        controlPanel.addControlFullWidth(Box.createHorizontalStrut(300));
        controlPanel.addControlFullWidth(new DischargeLampsLegend());
        Serializable serializable = new AtomTypeChooser(this.model, this.elementProperties);
        controlPanel.addControlFullWidth((Component)serializable);
        this.energyLevelsMonitorPanel = new DischargeLampEnergyMonitorPanel2(this.model, this.model.getAtomicStates(), 200, 300, this.configurableElement);
        controlPanel.addControl(this.energyLevelsMonitorPanel);
        this.electronProductionControl = new ElectronProductionControl(this, this.getMaxCurrent());
        this.electronProductionControl.setProductionMode(ElectronProductionControl.CONTINUOUS);
        serializable = new JDialog((Frame)PhetUtilities.getPhetFrame(), false);
        ((JDialog)serializable).getContentPane().add(this.electronProductionControl);
        ((Window)serializable).pack();
        ((Dialog)serializable).setVisible(false);
        PhetUtilities.getPhetFrame().getLayeredPane().add((Component)this.electronProductionControl, JLayeredPane.DRAG_LAYER);
        int n = DischargeLampsConfig.BEAM_CONTROL_CENTER_PT.x - this.electronProductionControl.getWidth() / 2;
        int n2 = DischargeLampsConfig.BEAM_CONTROL_CENTER_PT.y - this.electronProductionControl.getHeight() / 2 - 25;
        this.electronProductionControl.setLocation(n, n2);
        this.optionsPanel = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(-2, 40, -2, 0), 0, 0);
        this.optionsPanel.setBorder(new TitledBorder(DischargeLampsResources.getString("Controls.Options")));
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        final JCheckBox jCheckBox = new JCheckBox(DischargeLampsResources.getString("ControlPanel.SpectrometerButtonLabel"));
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DischargeLampModule.this.spectrometerGraphic.setVisible(jCheckBox.isSelected());
                DischargeLampModule.this.model.getSpectrometer().reset();
                DischargeLampModule.this.model.getSpectrometer().start();
            }
        });
        this.spectrometerGraphic.setVisible(jCheckBox.isSelected());
        this.squiggleCB = new JCheckBox(DischargeLampsResources.getString("Controls.Squiggles"));
        this.squiggleCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DischargeLampModule.this.energyLevelsMonitorPanel.setSquigglesEnabled(DischargeLampModule.this.squiggleCB.isSelected());
            }
        });
        jPanel.add(this.squiggleCB);
        this.optionsPanel.add((Component)jCheckBox, serializable);
        this.optionsPanel.add((Component)this.squiggleCB, serializable);
        this.optionsPanel.add((Component)new SlowMotionCheckBox((Clock)this.getClock()), serializable);
        controlPanel.addControlFullWidth(this.optionsPanel);
    }

    protected JComponent createClockControlPanel(IClock iClock) {
        JComponent jComponent = super.createClockControlPanel(iClock);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new ShowActualButton());
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    protected void addAtoms(Tube tube, int n, double d) {
        DischargeLampAtom dischargeLampAtom = null;
        ArrayList<DischargeLampAtom> arrayList = new ArrayList<DischargeLampAtom>();
        Rectangle2D rectangle2D = tube.getBounds();
        AtomicState[] atomicStateArray = this.model.getAtomicStates();
        for (int i = 0; i < n; ++i) {
            dischargeLampAtom = new DischargeLampAtom((LaserModel)this.getModel(), this.getDischargeLampModel().getElementProperties());
            dischargeLampAtom.setPosition(rectangle2D.getX() + Math.random() * (rectangle2D.getWidth() - dischargeLampAtom.getRadius() * 4.0) + dischargeLampAtom.getRadius() * 2.0, rectangle2D.getY() + Math.random() * (rectangle2D.getHeight() - dischargeLampAtom.getRadius() * 4.0) + dischargeLampAtom.getRadius() * 2.0);
            dischargeLampAtom.setVelocity((double)((float)(Math.random() - 0.5)) * d, (double)((float)(Math.random() - 0.5)) * d);
            arrayList.add(dischargeLampAtom);
            this.addAtom(dischargeLampAtom);
        }
        this.energyLevelsMonitorPanel.reset();
    }

    protected AtomGraphic addAtom(Atom atom) {
        this.energyLevelsMonitorPanel.addAtom(atom);
        this.getModel().addModelElement(atom);
        AnnotatedAtomGraphic annotatedAtomGraphic = new AnnotatedAtomGraphic(this.getApparatusPanel(), atom);
        atom.addPhotonEmittedListener(new InternalPhotonEmittedListener());
        atom.addLeftSystemListener(new AtomGraphicManager(annotatedAtomGraphic));
        this.getApparatusPanel().addGraphic(annotatedAtomGraphic, 119.0);
        if (this.random.nextBoolean()) {
            this.getApparatusPanel().removeGraphic(annotatedAtomGraphic);
            this.getApparatusPanel().addGraphic(annotatedAtomGraphic, 121.0);
        }
        return annotatedAtomGraphic;
    }

    public boolean hasHelp() {
        return false;
    }

    protected double getMaxCurrent() {
        return 150.0;
    }

    protected DischargeLampModel getDischargeLampModel() {
        return (DischargeLampModel)this.getModel();
    }

    protected Tube getTube() {
        return this.tube;
    }

    protected DischargeLampEnergyMonitorPanel2 getEneregyLevelsMonitorPanel() {
        return this.energyLevelsMonitorPanel;
    }

    public void setSquigglesEnabled(boolean bl) {
        this.squiggleCB.setSelected(true);
        this.energyLevelsMonitorPanel.setSquigglesEnabled(this.squiggleCB.isSelected());
    }

    public void setProductionType(ElectronProductionControl.ProductionMode productionMode) {
        if (productionMode == ElectronProductionControl.CONTINUOUS) {
            this.getEneregyLevelsMonitorPanel().setShowElectrons(false);
        }
        if (productionMode == ElectronProductionControl.SINGLE_SHOT) {
            this.getEneregyLevelsMonitorPanel().setShowElectrons(true);
        }
    }

    protected void setElectronProductionMode(ElectronProductionControl.ProductionMode productionMode) {
        this.electronProductionControl.setProductionMode(productionMode);
    }

    public class AtomGraphicManager
    implements Atom.LeftSystemListener {
        private AtomGraphic atomGraphic;

        public AtomGraphicManager(AtomGraphic atomGraphic) {
            this.atomGraphic = atomGraphic;
        }
    }

    public class InternalPhotonEmittedListener
    implements PhotonEmissionListener {
        public void photonEmitted(PhotonEmittedEvent photonEmittedEvent) {
            Photon photon = photonEmittedEvent.getPhoton();
            DischargeLampModule.this.getModel().addModelElement(photon);
            PhotonGraphic photonGraphic = PhotonGraphic.getInstance(DischargeLampModule.this.getApparatusPanel(), photon);
            photonGraphic.setVisible(true);
            DischargeLampModule.this.addGraphic(photonGraphic, 13.0);
            photon.addLeftSystemListener(new PhotonGraphicManager(photon, photonGraphic));
        }
    }

    public class PhotonGraphicManager
    implements Photon.LeftSystemEventListener {
        private PhotonGraphic graphic;

        public PhotonGraphicManager(Photon photon, PhotonGraphic photonGraphic) {
            this.graphic = photonGraphic;
        }

        public void leftSystemEventOccurred(Photon.LeftSystemEvent leftSystemEvent) {
            DischargeLampModule.this.getApparatusPanel().removeGraphic(this.graphic);
            DischargeLampModule.this.getApparatusPanel().repaint(this.graphic.getBounds());
            this.graphic = null;
        }
    }
}

