/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class PhetUtilities {
    private static ArrayList pendingRunnables = new ArrayList();

    public static void invokeLater(Runnable runnable) {
        pendingRunnables.add(runnable);
        Module module = PhetUtilities.getActiveModule();
        if (module != null) {
            IClock iClock = module.getClock();
            for (int i = 0; i < pendingRunnables.size(); ++i) {
                Runnable runnable2 = (Runnable)pendingRunnables.get(i);
                if (iClock instanceof SwingClock) {
                    SwingUtilities.invokeLater(runnable2);
                    continue;
                }
                runnable2.run();
            }
            pendingRunnables.clear();
        }
    }

    public static Module getActiveModule() {
        return PhetApplication.getInstance().getActiveModule();
    }

    public static PhetFrame getPhetFrame() {
        return PhetApplication.getInstance().getPhetFrame();
    }

    public static IClock getActiveClock() {
        return PhetUtilities.getActiveModule().getClock();
    }

    public static int getOperatingSystem() {
        String string = "";
        try {
            string = System.getProperty("os.name");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = 2;
        if (string.toLowerCase().indexOf("windows") >= 0) {
            n = 0;
        } else if (string.startsWith("Mac OS X")) {
            n = 1;
        }
        return n;
    }

    public static boolean isMacintosh() {
        return PhetUtilities.getOperatingSystem() == 1;
    }

    public static boolean isMacOS_10_4() {
        String string;
        boolean bl = false;
        if (PhetUtilities.isMacintosh() && (string = System.getProperty("os.version")) != null) {
            bl = string.startsWith("10.4");
        }
        return bl;
    }

    public static String getJavaPath() {
        return System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "java";
    }
}

