/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.collision;

import edu.colorado.phet.common.collision.Box2D;
import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.Collision;
import edu.colorado.phet.common.collision.CollisionExpert;
import edu.colorado.phet.common.collision.SphereBoxCollision;
import edu.colorado.phet.common.collision.SphericalBody;

public class SphereBoxExpert
implements CollisionExpert {
    private Collision collision;

    public boolean detectAndDoCollision(Collidable collidable, Collidable collidable2) {
        boolean bl = false;
        if (this.applies(collidable, collidable2) && this.areInContact(collidable, collidable2)) {
            SphericalBody sphericalBody = collidable instanceof SphericalBody ? (SphericalBody)collidable : (SphericalBody)collidable2;
            Box2D box2D = collidable instanceof Box2D ? (Box2D)collidable : (Box2D)collidable2;
            this.collision = new SphereBoxCollision(sphericalBody, box2D);
            this.collision.collide();
            bl = true;
        }
        return bl;
    }

    public boolean applies(Collidable collidable, Collidable collidable2) {
        return collidable instanceof SphericalBody && collidable2 instanceof Box2D || collidable instanceof Box2D && collidable2 instanceof SphericalBody;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean areInContact(Collidable collidable, Collidable collidable2) {
        double d;
        SphericalBody sphericalBody;
        boolean bl = false;
        Box2D box2D = null;
        if (collidable instanceof Box2D) {
            box2D = (Box2D)collidable;
            if (!(collidable2 instanceof SphericalBody)) throw new RuntimeException("bad args");
            sphericalBody = (SphericalBody)collidable2;
        } else {
            if (!(collidable2 instanceof Box2D)) throw new RuntimeException("bad args");
            box2D = (Box2D)collidable2;
            if (!(collidable instanceof SphericalBody)) throw new RuntimeException("bad args");
            sphericalBody = (SphericalBody)collidable;
        }
        double d2 = sphericalBody.getCenter().getX() - sphericalBody.getRadius() - box2D.getMinX();
        if (d2 <= 0.0) {
            bl = true;
        }
        if ((d2 = sphericalBody.getCenter().getX() + sphericalBody.getRadius() - box2D.getMaxX()) >= 0.0 && sphericalBody.getVelocity().getX() > 0.0) {
            bl = true;
        }
        if ((d = sphericalBody.getCenter().getY() - sphericalBody.getRadius() - box2D.getMinY()) <= 0.0 && sphericalBody.getVelocity().getY() < 0.0) {
            bl = true;
        }
        if (!((d = sphericalBody.getCenter().getY() + sphericalBody.getRadius() - box2D.getMaxY()) >= 0.0)) return bl;
        if (!(sphericalBody.getVelocity().getY() > 0.0)) return bl;
        return true;
    }
}

