/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;

public abstract class DB {
    final Mongo _mongo;
    final String _name;
    protected boolean _readOnly = false;
    private WriteConcern _concern;
    final Bytes.OptionHolder _options;
    String _username;
    byte[] _authhash = null;

    public DB(Mongo mongo, String name) {
        this._mongo = mongo;
        this._name = name;
        this._options = new Bytes.OptionHolder(this._mongo._netOptions);
    }

    protected abstract DBCollection doGetCollection(String var1);

    public final DBCollection getCollection(String name) {
        DBCollection c = this.doGetCollection(name);
        return c;
    }

    public CommandResult command(DBObject cmd) throws MongoException {
        return this.command(cmd, 0);
    }

    public CommandResult command(DBObject cmd, int options, ReadPreference readPrefs) throws MongoException {
        Iterator<DBObject> i = this.getCollection("$cmd").__find(cmd, new BasicDBObject(), 0, -1, 0, options, readPrefs, DefaultDBDecoder.FACTORY.create());
        if (i == null || !i.hasNext()) {
            return null;
        }
        DBObject res = i.next();
        ServerAddress sa = i instanceof DBApiLayer.Result ? ((DBApiLayer.Result)i).getServerAddress() : null;
        CommandResult cr = new CommandResult(sa);
        cr.putAll(res);
        cr._cmd = cmd;
        return cr;
    }

    public CommandResult command(DBObject cmd, int options) throws MongoException {
        return this.command(cmd, options, null);
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._mongo.getWriteConcern();
    }

    public boolean authenticate(String username, char[] passwd) throws MongoException {
        if (username == null || passwd == null) {
            throw new NullPointerException("username can't be null");
        }
        if (this._username != null) {
            throw new IllegalStateException("can't call authenticate twice on the same DBObject");
        }
        String hash = this._hash(username, passwd);
        CommandResult res = this._doauth(username, hash.getBytes());
        if (!res.ok()) {
            return false;
        }
        this._username = username;
        this._authhash = hash.getBytes();
        return true;
    }

    DBObject _authCommand(String nonce) {
        if (this._username == null || this._authhash == null) {
            throw new IllegalStateException("no auth info!");
        }
        return DB._authCommand(nonce, this._username, this._authhash);
    }

    static DBObject _authCommand(String nonce, String username, byte[] hash) {
        String key = nonce + username + new String(hash);
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("authenticate", (Object)1);
        cmd.put("user", (Object)username);
        cmd.put("nonce", (Object)nonce);
        cmd.put("key", (Object)Util.hexMD5(key.getBytes()));
        return cmd;
    }

    private CommandResult _doauth(String username, byte[] hash) {
        CommandResult res = this.command(new BasicDBObject("getnonce", (Object)1));
        res.throwOnError();
        DBObject cmd = DB._authCommand(res.getString("nonce"), username, hash);
        return this.command(cmd);
    }

    String _hash(String username, char[] passwd) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(username.length() + 20 + passwd.length);
        try {
            bout.write(username.getBytes());
            bout.write(":mongo:".getBytes());
            for (int i = 0; i < passwd.length; ++i) {
                if (passwd[i] >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)passwd[i]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return Util.hexMD5(bout.toByteArray());
    }

    public Mongo getMongo() {
        return this._mongo;
    }

    public abstract void cleanCursors(boolean var1) throws MongoException;
}

