/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerError;

public class CommandResult
extends BasicDBObject {
    DBObject _cmd;
    ServerAddress _host = null;

    CommandResult(ServerAddress srv) {
        this._host = srv;
        this.put("serverUsed", (Object)srv.toString());
    }

    public boolean ok() {
        Object o = this.get("ok");
        if (o == null) {
            throw new IllegalArgumentException("'ok' should never be null...");
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() == 1;
        }
        throw new IllegalArgumentException("can't figure out what to do with: " + o.getClass().getName());
    }

    public MongoException getException() {
        if (!this.ok()) {
            String cmdName = this._cmd.keySet().iterator().next();
            StringBuilder buf = new StringBuilder("command failed [");
            buf.append("command failed [").append(cmdName).append("] ");
            buf.append(this.toString());
            return new CommandFailure(this, buf.toString());
        }
        if (this.hasErr()) {
            Object foo = this.get("err");
            int code = this.getCode();
            String s = foo.toString();
            if (code == 11000 || code == 11001 || s.startsWith("E11000") || s.startsWith("E11001")) {
                return new MongoException.DuplicateKey(code, s);
            }
            return new MongoException(code, s);
        }
        return null;
    }

    private int getCode() {
        int code = -1;
        if (this.get("code") instanceof Number) {
            code = ((Number)this.get("code")).intValue();
        }
        return code;
    }

    boolean hasErr() {
        Object o = this.get("err");
        return o != null && ((String)o).length() > 0;
    }

    public void throwOnError() throws MongoException {
        if (!this.ok() || this.hasErr()) {
            throw this.getException();
        }
    }

    static class CommandFailure
    extends MongoException {
        CommandFailure(CommandResult res, String msg) {
            super(ServerError.getCode(res), msg);
        }
    }
}

